/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.impl.aggregation;

import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.commondataformat.serialization.CdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.CdfSequenceSerializerFactory;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.RdfCdfSequenceSerializer;
import com.vmware.ph.client.api.exceptions.PhClientException;
import com.vmware.ph.client.api.impl.aggregation.Aggregator;
import com.vmware.ph.client.api.impl.aggregation.Buffer;
import com.vmware.ph.client.api.impl.aggregation.DataProcessorImpl;
import com.vmware.ph.client.api.impl.aggregation.RotatingFileBuffer;
import com.vmware.ph.common.StringUtil;
import com.vmware.ph.common.audit.PayloadAuditPersister;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.upload.service.UploadService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AggregatorFactory {
    private static AggregatorFactory theInstance = new AggregatorFactory();
    private static Map<String, AggregatorData> aggregatorsCache = new HashMap<String, AggregatorData>();
    private final HeaderProviderImpl headerProvider = new HeaderProviderImpl();
    private final BufferFactory bufferFactory = new BufferFactory();

    private AggregatorFactory() {
    }

    public static AggregatorFactory getInstance() {
        return theInstance;
    }

    public synchronized Aggregator getAggregator(String collectorId, String instanceId, long uploadPeriodMillis, long bufferSizeInBytes, String bufferFolder, PayloadAuditPersister payloadAuditPersister, UploadService uploadService, CeipConfigProvider ceipConfigProvider) {
        this.validateParameters(collectorId, instanceId, uploadPeriodMillis, bufferSizeInBytes, bufferFolder);
        if (!aggregatorsCache.containsKey(collectorId)) {
            this.updateAggregatorCache(collectorId, instanceId, uploadPeriodMillis, bufferSizeInBytes, bufferFolder, payloadAuditPersister, uploadService, ceipConfigProvider);
        }
        AggregatorData cached = aggregatorsCache.get(collectorId);
        return cached.aggregator;
    }

    private void updateAggregatorCache(final String collectorId, final String instanceId, long uploadPeriodMillis, long bufferSizeInBytes, String bufferFolder, PayloadAuditPersister payloadAuditPersister, UploadService uploadService, CeipConfigProvider ceipConfigProvider) {
        RotatingFileBuffer.HeaderProvider hp = new RotatingFileBuffer.HeaderProvider(){

            @Override
            public byte[] getHeader() {
                byte[] res = AggregatorFactory.this.headerProvider.getHeader(new PayloadEnvelope(new Collector(collectorId, instanceId)));
                return res;
            }
        };
        Buffer buffer = this.bufferFactory.getFileBuffer(bufferFolder, hp, bufferSizeInBytes);
        Aggregator aggregator = new Aggregator(collectorId, instanceId, uploadPeriodMillis, buffer, new DataProcessorImpl(payloadAuditPersister), uploadService, ceipConfigProvider);
        aggregatorsCache.put(collectorId, new AggregatorData(collectorId, instanceId, uploadPeriodMillis, bufferSizeInBytes, bufferFolder, aggregator));
    }

    private void validateParameters(String collectorId, String instanceId, long uploadPeriodMillis, long bufferSizeInBytes, String bufferFolder) {
        StringUtil.throwOnBlankString(collectorId, "The PhoneHome buffering feature requires a non-blank collectorId value, but the provided value is blank. As a result the PhoneHome client initialization fails. Please provide a non-blank value.");
        StringUtil.throwOnBlankString(bufferFolder, "The PhoneHome buffering feature requires a non-blank bufferFolder value, but the provided value is blank. As a result the PhoneHome client initialization fails. Please provide a non-blank value.");
        if (uploadPeriodMillis <= 0L) {
            throw new IllegalArgumentException("The PhoneHome buffering feature requires a positive uploadPeriodMillis value, but the provided value is " + uploadPeriodMillis + " As a result the PhoneHome client initialization fails. Please provide a positive value.");
        }
        if (bufferSizeInBytes <= 0L) {
            throw new IllegalArgumentException("The PhoneHome buffering feature requires a positive bufferSizeInBytes value, but the provided value is " + bufferSizeInBytes + " As a result the PhoneHome client initialization fails. Please provide a positive value.");
        }
        if (aggregatorsCache.containsKey(collectorId)) {
            this.verifyTheSameAggregatorInstance(collectorId, instanceId, uploadPeriodMillis, bufferSizeInBytes, bufferFolder, aggregatorsCache.get(collectorId));
        } else {
            this.verifyBufferFolderNotUsedByOtherCollector(bufferFolder, collectorId);
        }
    }

    private void verifyTheSameAggregatorInstance(String collectorId, String instanceId, long uploadPeriodMillis, long bufferSizeInBytes, String bufferFolder, AggregatorData cachedAggregatorParams) {
        this.verifyEqualInstanceIds(instanceId, cachedAggregatorParams.instanceId, collectorId);
        this.verifyEqualUploadPeriodMillis(uploadPeriodMillis, cachedAggregatorParams.uploadPeriodMillis, collectorId);
        this.verifyEqualBufferSizeInBytes(bufferSizeInBytes, cachedAggregatorParams.bufferSizeInBytes, collectorId);
        this.verifyEqualBufferFolders(bufferFolder, cachedAggregatorParams.bufferFolder, collectorId);
    }

    private void verifyEqualInstanceIds(String instanceId, String cachedInstanceId, String collectorId) {
        if (instanceId == null && cachedInstanceId == null) {
            return;
        }
        if (instanceId == null && cachedInstanceId != null || !instanceId.equals(cachedInstanceId)) {
            throw new PhClientException("The PhoneHome buffering feature is supposed to work with a single instanceId value for concrete collectorId. You are trying to create a client with collectorId=" + collectorId + " and instanceId=" + instanceId + " but you have already created a client with collectorId=" + collectorId + " and instanceId=" + cachedInstanceId + ". As a result, the current PhoneHome client creation attempt fails. Please provide the same instanceId as the one already used.");
        }
    }

    private void verifyEqualUploadPeriodMillis(long uploadPeriodMillis, long cachedUploadPeriodMillis, String collectorId) {
        if (uploadPeriodMillis != cachedUploadPeriodMillis) {
            throw new PhClientException("The PhoneHome buffering feature is supposed to work with a single uploadPeriodMillis value for concrete collectorId. You are trying to create a client with collectorId=" + collectorId + " and uploadPeriodMillis=" + uploadPeriodMillis + " but you have already created a client with collectorId=" + collectorId + " and uploadPeriodMillis=" + cachedUploadPeriodMillis + ". As a result, the current PhoneHome client creation attempt fails. Please provide the same uploadPeriodMillis as the one already used.");
        }
    }

    private void verifyEqualBufferSizeInBytes(long bufferSizeInBytes, long cachedBufferSizeInBytes, String collectorId) {
        if (bufferSizeInBytes != cachedBufferSizeInBytes) {
            throw new PhClientException("The PhoneHome buffering feature is supposed to work with a single bufferSizeInBytes value for concrete collectorId. You are trying to create a client with collectorId=" + collectorId + " and bufferSizeInBytes=" + bufferSizeInBytes + " but you have already created a client with collectorId=" + collectorId + " and bufferSizeInBytes=" + cachedBufferSizeInBytes + ". As a result, the current PhoneHome client creation attempt fails. Please provide the same bufferSizeInBytes as the one already used.");
        }
    }

    private void verifyEqualBufferFolders(String bufferFolder, String cachedBufferFolder, String collectorId) {
        if (!bufferFolder.equals(cachedBufferFolder)) {
            throw new PhClientException("The PhoneHome buffering feature is supposed to work with a single bufferFolder value for concrete collectorId. You are trying to create a client with collectorId=" + collectorId + " and bufferFolder=" + bufferFolder + " but you have already created a client with collectorId=" + collectorId + " and bufferFolder=" + cachedBufferFolder + ". As a result, the current PhoneHome client creation attempt fails. Please provide the same bufferFolder as the one already used.");
        }
    }

    private void verifyBufferFolderNotUsedByOtherCollector(String bufferFolder, String collectorId) {
        for (AggregatorData params : aggregatorsCache.values()) {
            if (collectorId.equals(params.collectorId) || !bufferFolder.equals(params.bufferFolder)) continue;
            throw new PhClientException("The PhoneHome buffering feature is supposed to work with different bufferFolder values for different collectorIds. You are trying to create a client with collectorId=" + collectorId + " and bufferFolder=" + bufferFolder + " but in the current Java process a client is already created with collectorId=" + params.collectorId + " and bufferFolder=" + params.bufferFolder + ". As a result, the current PhoneHome client creation attempt fails." + " This is done, so that data from different collectors is not merged in the same buffering folder, which would result in invalid data for both collectors." + " Please provide different bufferFolder from the one already used for collectorId=" + params.collectorId);
        }
    }

    static class NamespaceSerializerInstantiator {
        NamespaceSerializerInstantiator() {
        }

        public CdfSequenceSerializer create(ByteArrayOutputStream baos) throws IOException {
            RdfCdfSequenceSerializer namespacesSerializer = CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(baos);
            return namespacesSerializer;
        }
    }

    static class BufferFactory {
        BufferFactory() {
        }

        public Buffer getFileBuffer(String aggregationFolder, RotatingFileBuffer.HeaderProvider hp, long bufferSizeInBytes) {
            RotatingFileBuffer buffer = new RotatingFileBuffer(new File(aggregationFolder), hp, bufferSizeInBytes / 5L, 5);
            return buffer;
        }
    }

    static class HeaderProviderImpl {
        private final NamespaceSerializerInstantiator namespaceSerializerInstantiator = new NamespaceSerializerInstantiator();

        public byte[] getHeader(PayloadEnvelope envelope) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                CdfSequenceSerializer namespacesSerializer = this.namespaceSerializerInstantiator.create(baos);
                namespacesSerializer.write(envelope);
                namespacesSerializer.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new Bug("There was a bug during initialization of the buffering feature. As a result PhClient cannot be created. Please contact PhoneHome team.");
            }
        }
    }

    static class AggregatorData {
        String collectorId;
        String instanceId;
        long uploadPeriodMillis;
        long bufferSizeInBytes;
        String bufferFolder;
        Aggregator aggregator;

        public AggregatorData(String collectorId, String instanceId, long uploadPeriodMillis, long bufferSizeInBytes, String bufferFolder, Aggregator aggregator) {
            this.collectorId = collectorId;
            this.instanceId = instanceId;
            this.uploadPeriodMillis = uploadPeriodMillis;
            this.bufferSizeInBytes = bufferSizeInBytes;
            this.bufferFolder = bufferFolder;
            this.aggregator = aggregator;
        }
    }
}

