/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.audit;

import com.vmware.ph.common.audit.AuditFileConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggerWriter
extends Writer {
    static final int BUFFER_SIZE = 1024;
    private char[] buffer = new char[1024];
    private int counter = 0;
    private static FileHandlerFactory FILE_HANDLER_FACTORY = new FileHandlerFactory();
    private FileHandler fileHandler;
    private boolean isClosed = false;

    public LoggerWriter(AuditFileConfig config) throws SecurityException, IOException {
        this.fileHandler = FILE_HANDLER_FACTORY.createFileHandler(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("Writing to closed stream.");
            }
            while (len > 1024 - this.counter) {
                System.arraycopy(cbuf, off, this.buffer, this.counter, 1024 - this.counter);
                off += 1024 - this.counter;
                len -= 1024 - this.counter;
                this.counter = 1024;
                this.flush();
            }
            System.arraycopy(cbuf, off, this.buffer, this.counter, len);
            this.counter += len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("Flushing closed stream.");
            }
            this.fileHandler.publish(new LogRecord(Level.INFO, new String(this.buffer, 0, this.counter)));
            this.buffer = new char[1024];
            this.counter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            this.fileHandler.close();
            this.isClosed = true;
        }
    }

    static class FileHandlerFactory {
        FileHandlerFactory() {
        }

        public FileHandler createFileHandler(AuditFileConfig config) throws SecurityException, IOException {
            FileHandler handler = new FileHandler(config.getFilePath() + ".%g", config.getMaxFileSizeBytes(), config.getMaxHistory(), true);
            Formatter formatter = new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            };
            handler.setFormatter(formatter);
            return handler;
        }
    }
}

