/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps;

import com.vmware.ph.client.common.extensions.ps.DefaultProxySettingsValidator;
import com.vmware.ph.client.common.extensions.ps.ProxyProviderFactory;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsValidator;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOrigin;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOriginProvider;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.extension.ProxyAutodiscoveryExtension;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.http.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AutodiscoveredProxySettingsProvider
implements ProxyAutodiscoveryExtension {
    private static final Logger log = LoggerFactory.getLogger(AutodiscoveredProxySettingsProvider.class);
    private static final DateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    public static final long MINIMAL_FRESH_PERIOD = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    public static final URI DEFAULT_CONNECTION_TEST_URI = URI.create("http://www.vmware.com");
    private final Collection<String> proxyAuthenticationSchemes;
    private long lastChange;
    private long freshPeriod;
    private ProxySettings proxySettings;
    private ProxySettingsWithOriginProvider provider;
    private ProxySettingsValidator validator;

    public AutodiscoveredProxySettingsProvider() {
        this.provider = ProxyProviderFactory.getDefaultProvider(DEFAULT_CONNECTION_TEST_URI);
        this.validator = new DefaultProxySettingsValidator(DEFAULT_CONNECTION_TEST_URI);
        this.freshPeriod = MINIMAL_FRESH_PERIOD;
        this.proxySettings = ProxySettings.NO_PROXY;
        this.lastChange = Long.MIN_VALUE;
        this.proxyAuthenticationSchemes = ProxySettings.DEFAULT_PROXY_AUTHENTICATION_SCHEMES;
    }

    public AutodiscoveredProxySettingsProvider(long freshPeriod, URI connectionTestUri) {
        this(freshPeriod, connectionTestUri, ProxySettings.DEFAULT_PROXY_AUTHENTICATION_SCHEMES);
    }

    public AutodiscoveredProxySettingsProvider(long freshPeriod, URI connectionTestUri, Collection<String> proxyAuthenticationSchemes) {
        this.provider = ProxyProviderFactory.getDefaultProvider(connectionTestUri);
        this.validator = new DefaultProxySettingsValidator(connectionTestUri);
        this.freshPeriod = Math.min(MINIMAL_FRESH_PERIOD, freshPeriod);
        this.proxySettings = ProxySettings.NO_PROXY;
        this.lastChange = Long.MIN_VALUE;
        this.proxyAuthenticationSchemes = proxyAuthenticationSchemes;
    }

    @Override
    public synchronized ProxySettings getProxySettings(HttpConnectionConfig connectionConfig) {
        if (!this.isFresh()) {
            this.refresh(connectionConfig);
        }
        log.debug("Providing proxy settings {} to the requestor.", (Object)this.proxySettings);
        return this.proxySettings;
    }

    boolean isFresh() {
        boolean shouldRefresh = this.lastChange + this.freshPeriod > System.currentTimeMillis();
        log.debug("Proxy settings were refreshed for the last time at {}. The refresh period is {} milliseconds. Refresh {} happen.", new Object[]{dateFormater.format(new Date(this.lastChange)), this.freshPeriod, shouldRefresh ? "will" : "will not"});
        return shouldRefresh;
    }

    synchronized void refresh(HttpConnectionConfig connectionConfig) {
        log.debug("Refreshing proxy settings with http connection config {}.", (Object)connectionConfig);
        Collection<ProxySettingsWithOrigin> collection = this.provider.getOptions();
        this.proxySettings = this.getFirstValidProxySettingsInCollection(collection, connectionConfig);
        this.lastChange = System.currentTimeMillis();
    }

    long getFreshPeriod() {
        return this.freshPeriod;
    }

    long getLastChange() {
        return this.lastChange;
    }

    void setProviderForUnitTestOnly(ProxySettingsWithOriginProvider provider) {
        this.provider = provider;
    }

    void setValidatorForUnitTestOnly(ProxySettingsValidator validator) {
        this.validator = validator;
    }

    void setRefreshPeriodForUnitTest(long freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    private ProxySettings getFirstValidProxySettingsInCollection(Collection<ProxySettingsWithOrigin> collection, HttpConnectionConfig connectionConfig) {
        log.debug("List of proxy settings from which will return the first valid one: {}", collection);
        for (ProxySettingsWithOrigin temp : collection) {
            assert (ProxySettings.DEFAULT_PROXY_AUTHENTICATION_SCHEMES.equals(this.proxySettings.getProxyAuthenticationSchemes()));
            temp.setProxyAuthenticationSchemes(this.proxyAuthenticationSchemes);
            if (!this.validator.isValid(temp, connectionConfig)) continue;
            log.debug("First valid proxy settings are {}.", (Object)temp);
            return temp;
        }
        log.debug("No valid ProxySettings found, defaulting to NO_PROXY settings.");
        return ProxySettings.NO_PROXY;
    }

    @Override
    public void setProxyConnectionTestUri(URI connectionTestUri) {
        this.provider = ProxyProviderFactory.getDefaultProvider(connectionTestUri);
        this.validator = new DefaultProxySettingsValidator(connectionTestUri);
    }

    public void setRefreshPeriod(long refreshPeriodInMinutes) {
        if (refreshPeriodInMinutes > MINIMAL_FRESH_PERIOD) {
            this.freshPeriod = refreshPeriodInMinutes;
        }
    }
}

