/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps.discovery;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import com.vmware.ph.client.common.extensions.ps.discovery.WinRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnaWinRegistry
implements WinRegistry {
    private static final Logger log = LoggerFactory.getLogger(JnaWinRegistry.class);

    @Override
    public Collection<String> getUserHkeys() {
        String[] apiResult = null;
        try {
            apiResult = Advapi32Util.registryGetKeys(WinReg.HKEY_USERS);
        }
        catch (RuntimeException e) {
            log.warn("Failed to retrieve HKEY_USERS subkeys.", (Throwable)e);
        }
        return apiResult != null ? Arrays.asList(apiResult) : Collections.emptyList();
    }

    @Override
    public String getHkeyUsersStringValue(String key, String valueName) {
        log.debug("Retrieving key HKEY_USERS\\ {} from registry.", (Object)key);
        String result = null;
        try {
            if (Advapi32Util.registryKeyExists(WinReg.HKEY_USERS, key)) {
                log.debug("Retrieving value {} from registry.", (Object)valueName);
                if (Advapi32Util.registryValueExists(WinReg.HKEY_USERS, key, valueName)) {
                    result = Advapi32Util.registryGetStringValue(WinReg.HKEY_USERS, key, valueName);
                }
            }
        }
        catch (RuntimeException e) {
            log.debug("Failed to retrieve key: HKEY_USERS\\" + key + " value: " + valueName + "from Windows registry.", (Throwable)e);
        }
        return result;
    }
}

