/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps.discovery.wpad.impl;

import com.vmware.ph.client.common.extensions.ps.discovery.Utils;
import com.vmware.ph.client.common.extensions.ps.discovery.wpad.PacScriptDiscoverer;
import com.vmware.ph.client.common.extensions.ps.discovery.wpad.exceptions.WpadException;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsPacScriptDiscoverer
implements PacScriptDiscoverer {
    private static final Logger log = LoggerFactory.getLogger(DnsPacScriptDiscoverer.class);

    @Override
    public URL discoverPacScript() throws WpadException {
        String fqdn;
        try {
            fqdn = Utils.obtainFqdn();
            log.debug("discovered fqdn = " + fqdn);
        }
        catch (UnknownHostException e) {
            log.error("While looking for this machine's domain, the local computer's hostname couldn't be resolved to an address. As a result WPAD autodiscovery through DNS will fail. Check DNS can resolve your machine's name.");
            throw new WpadException("Can't resolve local host name to an address.", e);
        }
        if (fqdn == null) {
            log.debug("No PAC script could be found on the network because there is no FQDN for the local machine.");
            return null;
        }
        String domain = fqdn;
        while ((domain = Utils.getNextLevelNonPublicDomain(domain)) != null) {
            try {
                URL scriptUrl = Utils.constructDnsWpadScriptUrl(domain);
                log.debug("Checking availability of PAC script URL candidate: {}", (Object)scriptUrl);
                if (Utils.checkPacAvailability(scriptUrl)) {
                    log.debug("There is a PAC script, it is accessible and will be used.");
                    return scriptUrl;
                }
                log.debug("There is no PAC script on that URL.");
            }
            catch (IOException e) {
                log.debug("While checking for availability of PAC script candidate.\nThere was an exception reading the script content, this may indicate a network problem. The PAC script may be otherwise valid and available but it will be skipped. Worst case scenario is that no proxy will be autodiscovered using WPAD mechanism,  tther proxy-autodiscovery mechanisms may still succeed (and even if they don't your upload may still be successful). Continuing.To avoid this warning in the future check your network connectivity (see the exception description that follows).", (Throwable)e);
            }
        }
        return null;
    }
}

