/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.upload.impl;

import com.vmware.ph.client.upload.impl.http.js8.UploaderImpl;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.upload.TransferProgressListener;
import com.vmware.ph.upload.Uploader;
import com.vmware.ph.upload.UploaderAbstractFactory;
import com.vmware.ph.upload.model.UploadAlgorithm;
import com.vmware.ph.upload.model.UploadServerInfo;
import org.apache.http.auth.UsernamePasswordCredentials;

public class UploaderFactory
implements UploaderAbstractFactory {
    @Override
    public Uploader buildUploader(UploadServerInfo serverInfo, ProxySettings proxySettings, TransferProgressListener progressListener, int maxResumesBeforeFailure, HttpConnectionConfig connectionConfig) {
        UploaderImpl u;
        UploadAlgorithm alg = serverInfo.algorithm;
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(serverInfo.credentials);
        String deploymentTypeFolderPrefix = "";
        switch (alg) {
            case JSCAPE_REST_v8: {
                u = new UploaderImpl(serverInfo.urlProtocol, serverInfo.urlHost, serverInfo.urlPort, creds.getUserName(), creds.getPassword(), serverInfo.chunkSize, proxySettings, deploymentTypeFolderPrefix, progressListener, maxResumesBeforeFailure, connectionConfig);
                break;
            }
            default: {
                throw new Bug("Algorithm " + (Object)((Object)alg) + " is not implemented.");
            }
        }
        return u;
    }
}

