/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.common;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsRestClientBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(TlsRestClientBuilderFactory.class);
    private static final String HTTPS_PROTOCOLS = System.getProperty("https.protocols", "TLSv1.1,TLSv1.2");
    private static final String HTTPS_CIPHER_SUITES = System.getProperty("https.cipherSuites");

    public HttpClientConnectionManager createCustomizedConnectionManager(TrustManager[] trustManagers) {
        PoolingHttpClientConnectionManager connManager = null;
        Object[] supportedSslProtocols = TlsRestClientBuilderFactory.split(HTTPS_PROTOCOLS);
        try {
            SSLContext sslContext = SSLContexts.custom().useTLS().build();
            if (trustManagers != null) {
                sslContext.init(null, trustManagers, null);
            }
            String[] supportedCipherSuites = TlsRestClientBuilderFactory.split(HTTPS_CIPHER_SUITES);
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (String[])supportedSslProtocols, supportedCipherSuites, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
            connManager = new PoolingHttpClientConnectionManager(registry);
            log.debug("Created PoolingHttpClientConnectionManager with support of the following SSL protocols: " + Arrays.asList(supportedSslProtocols));
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("There is a problem enabling '" + Arrays.toString(supportedSslProtocols) + "' as the only supported  SSL, client protocols. " + "Failing back to the default supported SSL protocols. In the case with Java 7 this means only  " + "TLS 1.0 will be enabled. The reason for the issue is : ", (Throwable)e);
        }
        return connManager;
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        return s.split(" *, *");
    }
}

