/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.upload.service;

import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.upload.Uploader;
import com.vmware.ph.upload.UploaderAbstractFactory;
import com.vmware.ph.upload.exception.ConnectionException;
import com.vmware.ph.upload.model.UploadDetails;
import com.vmware.ph.upload.model.UploadServerInfo;
import com.vmware.ph.upload.rest.PhRestClient;
import com.vmware.ph.upload.service.UploadService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UploadServiceImpl
implements UploadService {
    private static final String FAIL_UPLOAD_AFTER_TRYING_ALL_MESSAGE = "Failed to upload with server %s of %s: %s";
    private static final String RETRY_ERROR_MESSAGE = "Failed to get %s from ph-server for retry %s/%s; Reason: %s";
    private static final Logger log = LoggerFactory.getLogger(UploadServiceImpl.class);
    private final ExecutorService uploadTaskExecutor;
    private final UploadFacility uploadFacility;
    private final int maxRetries;
    private final ProxySettingsProvider proxySettingsProvider;
    private final PhRestClient phRestClient;
    private final HttpConnectionConfig connConfig;

    UploadServiceImpl(UploadFacility uploadFacility, int maxRetries, ProxySettingsProvider proxySettingsProvider, PhRestClient phRestClient, HttpConnectionConfig connConfig) {
        this.uploadFacility = uploadFacility;
        this.maxRetries = maxRetries;
        this.proxySettingsProvider = proxySettingsProvider;
        this.phRestClient = phRestClient;
        this.connConfig = connConfig;
        this.uploadTaskExecutor = this.singleThreadExecutorWithNamedThread("ph-file-upload-task");
    }

    @Override
    public Future<?> upload(String collectorId, String instanceId, String uploadId, InputStream stream, long size) throws ConnectionException {
        return this.upload(collectorId, instanceId, uploadId, null, stream, size);
    }

    @Override
    public Future<?> upload(String collectorId, String instanceId, final String uploadId, final String targetFileName, final InputStream stream, long size) throws ConnectionException {
        final UploadDetails uploadDetails = this.getUploadDetails(collectorId, instanceId, uploadId, size);
        if (uploadDetails == null) {
            log.debug("The UploadDetails object contains no servers to upload to so the upload finishes successfully. This situation may happen in case the client request a retry of upload with the same uploadId and the previous upload was succesfull.");
            return new Future<Void>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return true;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    return null;
                }

                @Override
                public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return null;
                }
            };
        }
        final long startTime = System.currentTimeMillis();
        Callable<Void> task = new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws ConnectionException {
                String currentThreadName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName("upload-" + uploadId);
                    if (uploadDetails.servers.serverInfos.length == 0) {
                        log.debug("The UploadDetails object contains no servers to upload to so the upload finishes successfully. This situation may happen in case the client request a retry of upload with the same uploadId and the previous upload was succesfull.");
                        Void void_ = null;
                        return void_;
                    }
                    int serverIndex = 0;
                    RuntimeException causeException = null;
                    for (UploadServerInfo serverInfo : uploadDetails.servers) {
                        long validForSeconds;
                        long startAfterSeconds;
                        if (Thread.currentThread().isInterrupted()) {
                            Void void_ = null;
                            return void_;
                        }
                        if (serverInfo.timeWindow != null) {
                            startAfterSeconds = serverInfo.timeWindow.startAfter;
                            validForSeconds = serverInfo.timeWindow.validFor;
                        } else {
                            startAfterSeconds = uploadDetails.servers.defaultTimeWindow.startAfter;
                            validForSeconds = uploadDetails.servers.defaultTimeWindow.validFor;
                        }
                        long now = System.currentTimeMillis();
                        if (startTime + (startAfterSeconds + validForSeconds) * 1000L < now) {
                            log.debug("The window of opportunity for upload is missed. There will be no upload for this server: " + serverInfo);
                            continue;
                        }
                        try {
                            long timePassedFromStartInSeconds = (now - startTime) / 1000L;
                            long timeToWindowStartInSeconds = startAfterSeconds - timePassedFromStartInSeconds;
                            TimeUnit.SECONDS.sleep(timeToWindowStartInSeconds);
                        }
                        catch (InterruptedException ie) {
                            log.warn(ie.getMessage(), (Throwable)ie);
                            Void void_ = null;
                            Thread.currentThread().setName(currentThreadName);
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                log.error("Error while cleaning up after stream-upload for uploadId = " + uploadId + ". The stream " + stream.getClass().getSimpleName() + " could not be closed. Upload is unaffected, swallowing - nothing we can do.", (Throwable)e);
                            }
                            return void_;
                        }
                        try {
                            UploadServiceImpl.this.uploadFacility.uploadStream(stream, targetFileName, UploadServiceImpl.this.maxRetries, serverInfo);
                            Void ie = null;
                            return ie;
                        }
                        catch (RuntimeException e) {
                            String message = String.format(UploadServiceImpl.FAIL_UPLOAD_AFTER_TRYING_ALL_MESSAGE, serverIndex + 1, uploadDetails.servers.serverInfos.length, serverInfo);
                            log.debug(message, (Throwable)e);
                            causeException = e;
                        }
                        finally {
                            ++serverIndex;
                        }
                    }
                    throw new ConnectionException("Upload failed after trying " + uploadDetails.servers.serverInfos.length + " servers.", causeException);
                }
                finally {
                    Thread.currentThread().setName(currentThreadName);
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        log.error("Error while cleaning up after stream-upload for uploadId = " + uploadId + ". The stream " + stream.getClass().getSimpleName() + " could not be closed. Upload is unaffected, swallowing - nothing we can do.", (Throwable)e);
                    }
                }
            }
        };
        return this.uploadTaskExecutor.submit(task);
    }

    @Override
    public String getManifest(final String collectorId, final String instanceId) throws ConnectionException {
        return this.executeWithRetry("manifest", new Callable<String>(){

            @Override
            public String call() throws Exception {
                String manifeset = UploadServiceImpl.this.phRestClient.getManifest(collectorId, instanceId);
                return manifeset;
            }
        });
    }

    @Override
    public void close() {
        this.shutdownExecutorService(this.uploadTaskExecutor);
        this.phRestClient.close();
    }

    private UploadDetails getUploadDetails(final String collectorId, final String instanceId, final String uploadId, final long sizeInBytes) throws ConnectionException {
        return this.executeWithRetry("upload details", new Callable<UploadDetails>(){

            @Override
            public UploadDetails call() throws Exception {
                return UploadServiceImpl.this.phRestClient.sendUploadRequest(collectorId, instanceId, uploadId, sizeInBytes);
            }
        });
    }

    private <T> T executeWithRetry(String resourceName, Callable<T> task) throws ConnectionException {
        ConnectionException clientException = null;
        RuntimeException rte = null;
        for (int i = 0; i < this.maxRetries; ++i) {
            String message;
            try {
                return task.call();
            }
            catch (ConnectionException phe) {
                message = String.format(RETRY_ERROR_MESSAGE, resourceName, i + 1, this.maxRetries, phe.getMessage());
                log.error(message, (Throwable)phe);
                clientException = phe;
            }
            catch (RuntimeException e) {
                message = String.format(RETRY_ERROR_MESSAGE, resourceName, i + 1, this.maxRetries, e.getMessage());
                log.error(message, (Throwable)e);
                rte = e;
            }
            catch (Exception e) {
                message = String.format(RETRY_ERROR_MESSAGE, resourceName, i + 1, this.maxRetries, e.getMessage());
                log.error(message, (Throwable)e);
                rte = new RuntimeException(e);
            }
            this.tryToRefreshProxySettings();
        }
        if (clientException != null) {
            throw clientException;
        }
        throw rte;
    }

    private synchronized void tryToRefreshProxySettings() {
        ProxySettings proxySettings = this.proxySettingsProvider.getProxySettings(this.connConfig);
        this.phRestClient.setProxySettings(proxySettings);
        this.uploadFacility.setProxySettings(proxySettings);
    }

    private void shutdownExecutorService(ExecutorService executorService) {
        executorService.shutdownNow();
        try {
            executorService.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("There was an error while closing the UploadService - an executor service was not shutdown. The upload operations are not affected, but potential system resources may not be freed. Swallowing - nothing we can do.", (Throwable)e);
        }
    }

    private ExecutorService singleThreadExecutorWithNamedThread(String threadName) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(threadName).daemon(true).build();
        return Executors.newSingleThreadExecutor(factory);
    }

    static class UploadFacility {
        private final UploaderAbstractFactory uploadFactory;
        private volatile ProxySettings proxySettings;
        private final HttpConnectionConfig connectionConfig;

        public UploadFacility(UploaderAbstractFactory factory, ProxySettings proxySettings, HttpConnectionConfig connectionConfig) {
            this.uploadFactory = factory;
            this.connectionConfig = connectionConfig;
            this.setProxySettings(proxySettings);
        }

        void setProxySettings(ProxySettings proxySettings) {
            this.proxySettings = proxySettings;
        }

        void uploadStream(InputStream streamToUpload, String targetFileName, int maxResumesBeforeFailure, UploadServerInfo serverInfo) {
            File targetFile = null;
            try {
                targetFile = new File(targetFileName);
            }
            catch (NullPointerException e) {
                targetFile = new File(serverInfo.targetFileName);
            }
            Uploader uploader = this.uploadFactory.buildUploader(serverInfo, this.proxySettings, null, maxResumesBeforeFailure, this.connectionConfig);
            uploader.uploadStream(streamToUpload, targetFile, serverInfo.shouldCreateFolder, this.proxySettings);
        }
    }
}

