/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.util.iterators.Iterators;

public class Models {
    protected Models() {
    }

    public static Value anyObject(Model m) {
        Value result = null;
        Set<Value> objects = m.objects();
        if (objects != null && !objects.isEmpty()) {
            result = objects.iterator().next();
        }
        return result;
    }

    public static Literal anyObjectLiteral(Model m) {
        Literal result = null;
        Set<Value> objects = m.objects();
        if (objects != null && !objects.isEmpty()) {
            for (Value v : objects) {
                if (!(v instanceof Literal)) continue;
                result = (Literal)v;
                break;
            }
        }
        return result;
    }

    public static Resource anyObjectResource(Model m) {
        Resource result = null;
        Set<Value> objects = m.objects();
        if (objects != null && !objects.isEmpty()) {
            for (Value v : objects) {
                if (!(v instanceof Resource)) continue;
                result = (Resource)v;
                break;
            }
        }
        return result;
    }

    public static URI anyObjectURI(Model m) {
        URI result = null;
        Set<Value> objects = m.objects();
        if (objects != null && !objects.isEmpty()) {
            for (Value v : objects) {
                if (!(v instanceof URI)) continue;
                result = (URI)v;
                break;
            }
        }
        return result;
    }

    public static Resource anySubject(Model m) {
        Resource result = null;
        Set<Resource> subjects = m.subjects();
        if (subjects != null && !subjects.isEmpty()) {
            result = subjects.iterator().next();
        }
        return result;
    }

    public static URI anySubjectURI(Model m) {
        URI result = null;
        Set<Resource> objects = m.subjects();
        if (objects != null && !objects.isEmpty()) {
            for (Value value : objects) {
                if (!(value instanceof URI)) continue;
                result = (URI)value;
                break;
            }
        }
        return result;
    }

    public static BNode anySubjectBNode(Model m) {
        BNode result = null;
        Set<Resource> objects = m.subjects();
        if (objects != null && !objects.isEmpty()) {
            for (Value value : objects) {
                if (!(value instanceof BNode)) continue;
                result = (BNode)value;
                break;
            }
        }
        return result;
    }

    public static URI anyPredicate(Model m) {
        URI result = null;
        Set<URI> predicates = m.predicates();
        if (predicates != null && !predicates.isEmpty()) {
            result = predicates.iterator().next();
        }
        return result;
    }

    public static Model setProperty(Model m, Resource subject, URI property, Value value, Resource ... contexts) {
        if (m == null) {
            throw new IllegalArgumentException("m may not be null");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject may not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("property may not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        if (m.contains(subject, property, null, contexts)) {
            m.remove(subject, property, null, contexts);
        }
        m.add(subject, property, value, contexts);
        return m;
    }

    public static boolean isomorphic(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Set<? extends Statement> set1 = Models.toSet(model1);
        Set<? extends Statement> set2 = Models.toSet(model2);
        if (set1.size() != set2.size()) {
            return false;
        }
        return Models.isSubsetInternal(set1, set2);
    }

    @Deprecated
    public static boolean equals(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        return Models.isomorphic(model1, model2);
    }

    public static boolean isSubset(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Set<? extends Statement> set1 = Models.toSet(model1);
        Set<? extends Statement> set2 = Models.toSet(model2);
        return Models.isSubset(set1, set2);
    }

    public static boolean isSubset(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        if (model1.size() > model2.size()) {
            return false;
        }
        return Models.isSubsetInternal(model1, model2);
    }

    private static boolean isSubsetInternal(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        return Models.matchModels(model1, model2);
    }

    private static boolean matchModels(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        ArrayList<Statement> model1BNodes = new ArrayList<Statement>(model1.size());
        for (Statement statement : model1) {
            if (statement.getSubject() instanceof BNode || statement.getObject() instanceof BNode) {
                model1BNodes.add(statement);
                continue;
            }
            if (model2.contains(statement)) continue;
            return false;
        }
        return Models.matchModels(model1BNodes, model2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchModels(List<? extends Statement> model1, Iterable<? extends Statement> model2, Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < model1.size()) {
            Statement st1 = model1.get(idx);
            List<Statement> matchingStats = Models.findMatchingStatements(st1, model2, bNodeMapping);
            for (Statement st2 : matchingStats) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                if (st1.getSubject() instanceof BNode && st2.getSubject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getSubject(), (BNode)st2.getSubject());
                }
                if (st1.getObject() instanceof BNode && st2.getObject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getObject(), (BNode)st2.getObject());
                }
                if (!(result = Models.matchModels(model1, model2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<Statement> findMatchingStatements(Statement st, Iterable<? extends Statement> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement statement : model) {
            if (!Models.statementsMatch(st, statement, bNodeMapping)) continue;
            result.add(statement);
        }
        return result;
    }

    private static boolean statementsMatch(Statement st1, Statement st2, Map<BNode, BNode> bNodeMapping) {
        BNode mappedBNode;
        BNode mappedBNode2;
        URI pred2;
        URI pred1 = st1.getPredicate();
        if (!pred1.equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        Resource subj2 = st2.getSubject();
        if (subj1 instanceof BNode && subj2 instanceof BNode ? ((mappedBNode2 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode2) : bNodeMapping.containsValue(subj2)) : !subj1.equals(subj2)) {
            return false;
        }
        Value obj1 = st1.getObject();
        Value obj2 = st2.getObject();
        return !(obj1 instanceof BNode && obj2 instanceof BNode ? ((mappedBNode = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode) : bNodeMapping.containsValue(obj2)) : !obj1.equals(obj2));
    }

    private static <S extends Statement> Set<S> toSet(Iterable<S> iterable) {
        HashSet set = null;
        if (iterable instanceof Set) {
            set = (HashSet)iterable;
        } else {
            set = new HashSet();
            Iterators.addAll(iterable.iterator(), set);
        }
        return set;
    }
}

