/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.datatypes;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.LiteralUtilException;
import org.openrdf.rio.DatatypeHandler;

public class GeoSPARQLDatatypeHandler
implements DatatypeHandler {
    @Override
    public boolean isRecognizedDatatype(URI datatypeUri) {
        if (datatypeUri == null) {
            throw new NullPointerException("Datatype URI cannot be null");
        }
        return datatypeUri.stringValue().startsWith("http://www.opengis.net/ont/geosparql#");
    }

    @Override
    public boolean verifyDatatype(String literalValue, URI datatypeUri) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return true;
        }
        throw new LiteralUtilException("Could not verify DBPedia literal");
    }

    @Override
    public Literal normalizeDatatype(String literalValue, URI datatypeUri, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return valueFactory.createLiteral(literalValue, datatypeUri);
        }
        throw new LiteralUtilException("Could not normalise DBPedia literal");
    }

    @Override
    public String getKey() {
        return "org.openrdf.rio.datatypes.geosparql";
    }
}

