/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.flex;

import com.vmware.vise.vim.extension.ScriptPluginUtil;
import com.vmware.vise.vim.extension.flex.DefaultExtensionHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ActionsSetsExtensionHandler
extends DefaultExtensionHandler {
    private static final Set<String> IGNORED_LIST = new HashSet<String>();
    private static final ActionsSetsExtensionHandler _instance;

    private ActionsSetsExtensionHandler() {
    }

    public static ActionsSetsExtensionHandler getInstance() {
        return _instance;
    }

    @Override
    public String handle(String string, Element element) {
        String string2 = element.getAttributeNode("id").getNodeValue();
        Node node = null;
        NodeList nodeList = element.getElementsByTagName("metadata");
        if (nodeList != null && nodeList.getLength() > 0) {
            node = nodeList.item(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList2 = element.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            String string3 = node2.getNodeName();
            if (!string3.equals("object")) continue;
            this.handleObjectElement(node2, stringBuffer, string2, node);
            break;
        }
        return stringBuffer.toString();
    }

    private void handleObjectElement(Node node, StringBuffer stringBuffer, String string, Node node2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.loadMetadata(node2, hashMap);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!hashMap.isEmpty()) {
            this.metadataToXml(hashMap, stringBuffer2);
        }
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("com.vmware.actionsfw.ActionSpec");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            NodeList nodeList2 = node3.getChildNodes();
            stringBuffer.append("<extension id='").append(string).append(".actionSpec").append(i + 1).append("'>");
            stringBuffer.append("<extendedPoint>vise.actions.specs</extendedPoint>");
            stringBuffer.append("<object>");
            if (string2 != null) {
                ActionsSetsExtensionHandler.appendElement("applicableTargetTypes", string2, stringBuffer);
            }
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node4 = nodeList2.item(j);
                String string3 = node4.getNodeName();
                if (string3.equals("icon")) {
                    this.transformIconElement((Element)node4, stringBuffer);
                    continue;
                }
                if (string3.equals("command") || string3.equals("delegate") || string3.equals("invokeEvent")) {
                    this.appendInvoker(stringBuffer);
                    continue;
                }
                if (string3.equals("conditionalProperty")) {
                    ActionsSetsExtensionHandler.appendElement("availabilityProperty", ScriptPluginUtil.getNodeValue((Element)node4), stringBuffer);
                    continue;
                }
                if (IGNORED_LIST.contains(string3)) continue;
                ActionsSetsExtensionHandler.appendElement(node4, stringBuffer);
            }
            stringBuffer.append("</object>");
            if (!hashMap.isEmpty()) {
                stringBuffer.append(stringBuffer2);
            }
            stringBuffer.append("</extension>");
        }
    }

    private void metadataToXml(Map<String, String> map, StringBuffer stringBuffer) {
        stringBuffer.append("<metadata>");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ActionsSetsExtensionHandler.appendElement(entry.getKey(), entry.getValue(), stringBuffer);
        }
        stringBuffer.append("</metadata>");
    }

    private String loadMetadata(Node node, Map<String, String> map) {
        String string = null;
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                NodeList nodeList2 = node2.getChildNodes();
                if (nodeList2 == null || nodeList2.getLength() <= 0) continue;
                String string2 = nodeList2.item(0).getNodeValue();
                if (node2.getNodeName().equals("objectType")) {
                    string = string2;
                    continue;
                }
                map.put(node2.getNodeName(), string2);
            }
        }
        return string;
    }

    private void appendInvoker(StringBuffer stringBuffer) {
        stringBuffer.append("<invoker>com.vise.actions.FlexActionInvoker</invoker>");
    }

    static {
        IGNORED_LIST.add("privateAction");
        IGNORED_LIST.add("category");
        _instance = new ActionsSetsExtensionHandler();
    }
}

