/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.flex;

import com.vmware.vise.vim.extension.flex.ActionsSetsExtensionHandler;
import com.vmware.vise.vim.extension.flex.DefaultExtensionHandler;
import com.vmware.vise.vim.extension.flex.ExtensionHandler;
import com.vmware.vise.vim.extension.flex.ListColumnExtensionHandler;
import com.vmware.vise.vim.extension.flex.ObjectNavigatorExtensionHandler;
import com.vmware.vise.vim.extension.flex.RelatedItemExtensionHandler;
import com.vmware.vise.vim.extension.flex.TemplateInstanceHandler;
import com.vmware.vise.vim.extension.flex.ViewExtensionHandler;
import java.util.HashMap;
import java.util.Map;

final class ExtensionHandlerFactory {
    private static ExtensionHandlerFactory _factory;
    private static Map<String, ExtensionHandler> handlersByExtensionPoint;
    static ExtensionHandler DEFAULT_HANDLER;
    static ExtensionHandler TEMPLATE_INSTNACE_HANDLER;

    ExtensionHandlerFactory() {
    }

    static ExtensionHandlerFactory getInstance() {
        return _factory;
    }

    ExtensionHandler getExtensionHandler(String string) {
        ExtensionHandler extensionHandler = handlersByExtensionPoint.get(string);
        if (extensionHandler == null) {
            for (String string2 : handlersByExtensionPoint.keySet()) {
                if (!string.endsWith(string2)) continue;
                return handlersByExtensionPoint.get(string2);
            }
            return DEFAULT_HANDLER;
        }
        return extensionHandler;
    }

    ExtensionHandler getTemplateInstanceHandler() {
        return TEMPLATE_INSTNACE_HANDLER;
    }

    static {
        String[] stringArray;
        _factory = new ExtensionHandlerFactory();
        handlersByExtensionPoint = new HashMap<String, ExtensionHandler>();
        handlersByExtensionPoint.put("vise.global.views", ViewExtensionHandler.getInstance());
        for (String string : stringArray = new String[]{"cluster", "datacenter", "dscluster", "dvs", "dvPortgroup", "folder", "host", "hp", "network", "resourcePool", "datastore", "vApp", "vm", "template"}) {
            handlersByExtensionPoint.put("vsphere.core." + string + ".summarySectionViews", ViewExtensionHandler.getInstance());
            handlersByExtensionPoint.put("vsphere.core." + string + ".summaryViews", ViewExtensionHandler.getInstance());
            handlersByExtensionPoint.put("vsphere.core." + string + ".monitorViews", ViewExtensionHandler.getInstance());
            handlersByExtensionPoint.put("vsphere.core." + string + ".monitor.performanceViews", ViewExtensionHandler.getInstance());
            handlersByExtensionPoint.put("vsphere.core." + string + ".manageViews", ViewExtensionHandler.getInstance());
            handlersByExtensionPoint.put("vsphere.core." + string + ".manage.settingsViews", ViewExtensionHandler.getInstance());
            handlersByExtensionPoint.put("vsphere.core." + string + ".manage.alarmDefinitionsViews", ViewExtensionHandler.getInstance());
        }
        handlersByExtensionPoint.put("vise.navigator.nodespecs", ObjectNavigatorExtensionHandler.getInstance());
        handlersByExtensionPoint.put("vise.relateditems.specs", RelatedItemExtensionHandler.getInstance());
        handlersByExtensionPoint.put("vise.actions.sets", ActionsSetsExtensionHandler.getInstance());
        for (String string : stringArray) {
            handlersByExtensionPoint.put("vsphere.core." + string + ".list.columns", ListColumnExtensionHandler.getInstance());
        }
        handlersByExtensionPoint.put(".summarySectionViews", ViewExtensionHandler.getInstance());
        handlersByExtensionPoint.put(".summaryViews", ViewExtensionHandler.getInstance());
        handlersByExtensionPoint.put(".monitorViews", ViewExtensionHandler.getInstance());
        handlersByExtensionPoint.put(".monitor.performanceViews", ViewExtensionHandler.getInstance());
        handlersByExtensionPoint.put(".manageViews", ViewExtensionHandler.getInstance());
        handlersByExtensionPoint.put(".manage.settingsViews", ViewExtensionHandler.getInstance());
        handlersByExtensionPoint.put(".manage.alarmDefinitionsViews", ViewExtensionHandler.getInstance());
        handlersByExtensionPoint.put(".list.columns", ListColumnExtensionHandler.getInstance());
        DEFAULT_HANDLER = new DefaultExtensionHandler();
        TEMPLATE_INSTNACE_HANDLER = new TemplateInstanceHandler();
    }
}

