/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.flex;

import com.vmware.vise.util.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ResourcesTransformer {
    private static final Log _logger = LogFactory.getLog(ResourcesTransformer.class);
    private static final String[] supportedLocales = new String[]{"-en_US", "-en", "-fr_FR", "-fr", "-de_DE", "-de", "-es_ES", "-es", "-ja_JP", "-ja", "-ko_KR", "-ko", "-zh_CN", "-zh", "_en_US", "_en", "_fr_FR", "_fr", "_de_DE", "_de", "_es_ES", "_es", "_ja_JP", "_ja", "_ko_KR", "_ko", "_zh_CN", "_zh"};
    private static final Pattern IMAGE_REG_EX = Pattern.compile("Embed\\(\"(\\S*)\"\\)");
    private static final Pattern PROPERTY_ENTRY_EX = Pattern.compile("(\\S*)\\s*=\\s*(\\S*)");
    private final JarFile _theBundle;

    ResourcesTransformer(JarFile jarFile) {
        this._theBundle = jarFile;
    }

    String processResources(File file, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        File file2 = file.getParentFile();
        ArrayList<File> arrayList = new ArrayList<File>();
        String string2 = this.processPropertiesFiles(file2, arrayList);
        stringBuffer.append(string2);
        String string3 = this.processImagesAndCss(file, arrayList);
        if (!string3.isEmpty()) {
            stringBuffer.append("<dependencies>");
            stringBuffer.append(string3);
            stringBuffer.append("</dependencies>");
        }
        return stringBuffer.toString();
    }

    private String processImagesAndCss(File file, List<File> list) {
        File file2;
        Object object2;
        Object object3;
        LinkedHashMap<String, InputStream> linkedHashMap = new LinkedHashMap<String, InputStream>();
        try {
            object3 = this._theBundle.entries();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                String object4 = ((ZipEntry)object2).getName();
                if (!object4.startsWith("assets")) continue;
                InputStream file22 = null;
                if (!object4.endsWith("/")) {
                    try {
                        file22 = this._theBundle.getInputStream((ZipEntry)object2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                linkedHashMap.put(object4, file22);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error in processing assets", (Throwable)exception);
        }
        if (linkedHashMap.isEmpty()) {
            _logger.info((Object)("No assets folder is fould at the bundle: " + this._theBundle.getName()));
            return "";
        }
        object3 = file.getParentFile();
        try {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                Object object;
                if (((String)entry.getKey()).endsWith("/")) {
                    int n = ((String)entry.getKey()).lastIndexOf("/");
                    object = new File((File)object3, ((String)entry.getKey()).substring(0, n));
                    ((File)object).mkdir();
                    continue;
                }
                File file3 = new File((File)object3, (String)entry.getKey());
                file3.createNewFile();
                object = (InputStream)entry.getValue();
                if (object == null) continue;
                FileUtil.writeFile((InputStream)object, (File)file3);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error in creating assets folder in bundle: " + this._theBundle.getName()), (Throwable)exception);
            return "";
        }
        if (list == null || list.isEmpty()) {
            _logger.info((Object)("No properties files are found in the bundle: " + this._theBundle.getName()));
            return "";
        }
        object2 = new File(file.getParentFile(), "assets");
        if (!((File)object2).exists()) {
            ((File)object2).mkdir();
        }
        if (!(file2 = new File((File)object2, "css")).exists()) {
            file2.mkdir();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (File file4 : list) {
            String string = this.processCssFile(file4, file2, ((File)object3).getName());
            if (string == null) continue;
            stringBuffer.append("<dependency type='css' uri='");
            stringBuffer.append("/").append(((File)object3).getName());
            stringBuffer.append("/assets/css/");
            stringBuffer.append(string);
            stringBuffer.append("'/>");
        }
        return stringBuffer.toString();
    }

    private String processCssFile(File file, File file2, String string) {
        try {
            CharSequence charSequence;
            String string2;
            Object object;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                object2 = PROPERTY_ENTRY_EX.matcher(string3);
                if (!((Matcher)object2).find()) {
                    stringBuffer2.append(string3).append("\n");
                    continue;
                }
                object = ((Matcher)object2).group(1);
                string2 = ((Matcher)object2).group(2);
                if (!((Matcher)(object2 = IMAGE_REG_EX.matcher(string2))).matches()) {
                    stringBuffer2.append(string3).append("\n");
                    continue;
                }
                String string4 = ((Matcher)object2).group(1);
                string4 = string4.substring(string4.lastIndexOf("/") + 1);
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("/").append(string);
                ((StringBuffer)charSequence).append("/assets/images/");
                ((StringBuffer)charSequence).append(string4);
                stringBuffer.append(".icon-").append((String)object).append("{");
                stringBuffer.append("background-image: ").append("url(").append((StringBuffer)charSequence).append(");");
                stringBuffer.append("}\n");
                stringBuffer2.append((String)object).append("=").append((StringBuffer)charSequence).append("\n");
            }
            bufferedReader.close();
            object2 = stringBuffer.toString();
            if (!((String)object2).isEmpty()) {
                object = new BufferedWriter(new FileWriter(file));
                ((Writer)object).write(stringBuffer2.toString());
                ((BufferedWriter)object).close();
                string2 = file.getName();
                int n = string2.indexOf(".properties");
                charSequence = string2.substring(0, n) + ".css";
                File file3 = new File(file2, (String)charSequence);
                if (!file3.exists()) {
                    file3.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(file3);
                fileWriter.append((CharSequence)object2);
                fileWriter.close();
                return file3.getName();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Unable to emit css file from the properties file: " + file), (Throwable)exception);
        }
        return null;
    }

    private String processPropertiesFiles(File file, List<File> list) {
        Object object;
        File file2 = new File(file, "locales");
        if (file2.exists()) {
            file2.delete();
        }
        file2.mkdir();
        String string = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            object = this._theBundle.entries();
            while (object.hasMoreElements()) {
                JarEntry jarEntry = object.nextElement();
                String string2 = jarEntry.getName();
                if (!string2.startsWith("locales/") || !string2.endsWith(".properties")) continue;
                string2 = string2.replace("locales/", "");
                string2 = string2.replace(".properties", "");
                this.addPropertiesFileName(hashSet, string2);
                string = jarEntry.getName().replace("locales/", "");
                string = string.replace('-', '_');
                File file3 = new File(file2, string);
                file3.createNewFile();
                InputStream inputStream = this._theBundle.getInputStream(jarEntry);
                FileUtil.writeFile((InputStream)inputStream, (File)file3);
                list.add(file3);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error in processing properties file: " + string), (Throwable)exception);
        }
        if (!hashSet.isEmpty()) {
            object = new StringBuffer();
            ((StringBuffer)object).append("<resources baseUrl='locales/'>");
            for (String string2 : hashSet) {
                ((StringBuffer)object).append("<resource>").append(string2).append("</resource>");
            }
            ((StringBuffer)object).append("</resources>");
            return ((StringBuffer)object).toString();
        }
        return "";
    }

    private void addPropertiesFileName(Set<String> set, String string) {
        for (String string2 : supportedLocales) {
            string = string.replace(string2, "");
        }
        set.add(string);
    }
}

