/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.h5;

import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.extension.PluginConstants;
import com.vmware.vise.vim.extension.ScriptPluginUtil;
import com.vmware.vise.vim.extension.h5.H5VcScriptPluginManager;
import com.vmware.vise.vim.extension.h5.HomeViewHandler;
import com.vmware.vise.vim.extension.h5.InventoryMenuHandler;
import com.vmware.vise.vim.extension.h5.InventoryViewHandler;
import com.vmware.vise.vim.extension.h5.MainMenuHandler;
import com.vmware.vise.vim.extension.h5.PluginHandler;
import com.vmware.vise.vim.extension.h5.PluginPackageHandler;
import com.vmware.vise.vim.scriptPlugin.ScriptPluginService;
import java.io.FileWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class H5VcScriptPluginTransformer {
    private static final Log _logger = LogFactory.getLog(H5VcScriptPluginManager.class);
    private final FileWriter _plugin;
    long _uniqueIdentifier = 0L;
    private final PluginPackageHandler _pluginPackageHandler;
    private final PluginHandler _pluginHandler;
    private final HomeViewHandler _homeViewHandler;
    private final InventoryViewHandler _inventoryViewHandler;
    private final InventoryMenuHandler _inventoryMenuHandler;
    private final MainMenuHandler _mainMenuHandler;

    public H5VcScriptPluginTransformer(ScriptPluginService scriptPluginService, VcService vcService, FileWriter fileWriter, FileWriter fileWriter2) {
        this._pluginHandler = new PluginHandler(this, scriptPluginService, vcService, fileWriter);
        this._homeViewHandler = new HomeViewHandler(this, scriptPluginService, vcService, fileWriter);
        this._inventoryViewHandler = new InventoryViewHandler(this, scriptPluginService, vcService, fileWriter);
        this._inventoryMenuHandler = new InventoryMenuHandler(this, scriptPluginService, vcService, fileWriter);
        this._mainMenuHandler = new MainMenuHandler(this, scriptPluginService, vcService, fileWriter);
        this._plugin = fileWriter;
        this._pluginPackageHandler = new PluginPackageHandler(fileWriter2);
    }

    public void processXml(Document document, String string) throws Exception {
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("scriptConfiguration");
        Element element = (Element)nodeList.item(0);
        String string2 = ScriptPluginUtil.getNodeFromDoc(document, "key");
        String string3 = element.getAttributeNode("version").getNodeValue();
        String string4 = ScriptPluginUtil.getNodeFromDoc(document, "description");
        this._pluginPackageHandler.handle(document, string2, string3, string4);
        String string5 = ScriptPluginUtil.getNodeFromDoc(document, "multiVCsupported");
        if (string5 == null) {
            string5 = "false";
        }
        this._plugin.write("<?xml version='1.0' encoding='UTF-8'?>");
        this._plugin.write("<plugin id='" + string2 + "'>");
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node = nodeList2.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("extension")) continue;
            Element element2 = (Element)node;
            String string6 = element2.getAttributeNode("parent").getNodeValue();
            if (string6 == null) {
                _logger.error((Object)("parent attribute not found in extension elements in script plugin: " + string));
                continue;
            }
            if (element2.hasAttribute("treestyle")) {
                _logger.warn((Object)("treeStyle attribute ignored in extension point: " + string6 + ", found in script plugin: " + string));
            }
            if (string6.split("\\.").length <= 0) {
                ScriptPluginUtil.logInvalidExtension(string6, string);
                continue;
            }
            String string7 = string6.split("\\.")[0];
            String string8 = string6.split("\\.")[1];
            string8 = PluginConstants.getLegacyType(string8);
            String string9 = ScriptPluginUtil.getNodeValue(element2, "url");
            if (string7.equals("HomeView")) {
                this._homeViewHandler.handle(element2, string2, string9, string8, string5);
            } else if (string7.equals("InventoryView")) {
                this._inventoryViewHandler.handle(element2, string2, string9, string5);
            } else if (string7.equals("InventoryMenus")) {
                NodeList nodeList3 = element2.getElementsByTagName("url");
                Element element3 = (Element)nodeList3.item(0);
                String string10 = "browser";
                if (element3.hasAttribute("display")) {
                    string10 = element3.getAttributeNode("display").getNodeValue();
                }
                this._inventoryMenuHandler.addToInventoryMenusList(string2, string4, element2, node, string8, string10);
            } else if (string7.equals("MainMenus")) {
                this._mainMenuHandler.handle(element2, node, string2, string8, string8, true);
            } else if (string7.equals("Toolbars")) {
                _logger.warn((Object)("The toolbar extension found in script plugin " + string + " are not supported in vSphere Web Client!"));
            } else {
                ScriptPluginUtil.logInvalidExtension(string6, string);
                continue;
            }
            if (string7.equals("InventoryMenus")) continue;
            this._pluginHandler.processMetaData(element2, node.getChildNodes(), string7, string8);
        }
        this._inventoryMenuHandler.handle(string2, string4);
        this._plugin.append("</plugin>");
        this._plugin.close();
        this._uniqueIdentifier = 0L;
    }
}

