/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.h5;

import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.extension.PluginConstants;
import com.vmware.vise.vim.extension.ScriptPluginUtil;
import com.vmware.vise.vim.extension.h5.DataRepository;
import com.vmware.vise.vim.extension.h5.H5VcScriptPluginManager;
import com.vmware.vise.vim.extension.h5.H5VcScriptPluginTransformer;
import com.vmware.vise.vim.scriptPlugin.ScriptPluginService;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class PluginHandler {
    static final Log _logger = LogFactory.getLog(H5VcScriptPluginManager.class);
    H5VcScriptPluginTransformer _transformer;
    ScriptPluginService _scriptPluginService;
    VcService _vcService;
    FileWriter _plugin;

    PluginHandler(H5VcScriptPluginTransformer h5VcScriptPluginTransformer, ScriptPluginService scriptPluginService, VcService vcService, FileWriter fileWriter) {
        this._transformer = h5VcScriptPluginTransformer;
        this._scriptPluginService = scriptPluginService;
        this._vcService = vcService;
        this._plugin = fileWriter;
    }

    void processMetaData(Element element, NodeList nodeList, String string, String string2) throws IOException {
        boolean bl;
        boolean bl2 = nodeList != null && nodeList.getLength() != 0;
        boolean bl3 = element.getAttributeNode("privilege") != null;
        boolean bl4 = string.equals("InventoryMenus");
        boolean bl5 = bl = !string.equals("Toolbars") && !string.equals("MainMenus");
        if ((bl2 || bl3 || bl4) && bl) {
            this._plugin.append("<metadata>");
            if (PluginConstants.folderTypeContains(string2)) {
                String string3 = DataRepository.getSchema("Folder");
                string3 = ScriptPluginUtil.replace(string3, "$folderType", PluginConstants.getFolderType(string2));
                this._plugin.append(string3);
            } else if (string.equals("InventoryMenus")) {
                this._plugin.append("<objectType>" + string2 + "</objectType>");
            }
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (!nodeList.item(i).getNodeName().equals("customAttribute")) continue;
                    String string4 = ((Element)nodeList.item(i)).getAttributeNode("name").getNodeValue();
                    String string5 = ScriptPluginUtil.getNodeValue(element, "customAttribute");
                    this._plugin.append(PluginHandler.getCustomAttributeMetadata(string4, string5));
                }
            }
            if (element.getAttributeNode("privilege") != null) {
                this._plugin.append("<privilege>");
                this._plugin.append(element.getAttributeNode("privilege").getNodeValue());
                this._plugin.append("</privilege>");
            }
            this._plugin.append("</metadata>");
            if (string.equals("HomeView") || string.equals("InventoryView")) {
                this._plugin.append("</extension>");
            }
        }
    }

    public static String getCustomAttributeMetadata(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append(string).append(">");
        stringBuffer.append(string2);
        stringBuffer.append("</").append(string).append(">");
        return stringBuffer.toString();
    }
}

