/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http.transport;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.http.transport.urlResolver.IUploadUrlResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.springframework.http.HttpMethod;
import org.springframework.web.HttpRequestHandler;

public class FileUploadRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(FileUploadRequestHandler.class);
    private static final int ONE_MB = 0x100000;
    private static final String VC_SERVICE_GUID_PARAM = "vcServerGuid";
    private static final String SESSION_COOKIE_NAME = "vmware_soap_session";
    ImmutableList<String> supportedMethods = ImmutableList.of((Object)HttpMethod.POST.toString(), (Object)HttpMethod.PUT.toString());
    private KeystoreService _keystoreService;
    private List<IUploadUrlResolver> _uploadUrlResolvers;
    private int _bufferSizeInBytes = 0x100000;

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setUploadUrlResolvers(List<IUploadUrlResolver> list) {
        this._uploadUrlResolvers = list;
    }

    public void setBufferSizeInBytes(int n) {
        this._bufferSizeInBytes = n;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (this.supportedMethods.contains((Object)string)) {
            this.doRequest(httpServletRequest, httpServletResponse);
        } else {
            FileUploadRequestHandler.returnResponse(httpServletResponse, 405, string + " request method is not supported.");
        }
    }

    private SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException {
        SSLContext sSLContext = SSLContexts.custom().loadTrustMaterial(this._keystoreService.getKeyStore()).build();
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory;
    }

    private URL resolveUrl(HttpServletRequest httpServletRequest) throws MalformedURLException {
        URL uRL = null;
        boolean bl = false;
        if (this._uploadUrlResolvers != null && this._uploadUrlResolvers.size() > 0) {
            for (IUploadUrlResolver iUploadUrlResolver : this._uploadUrlResolvers) {
                bl = iUploadUrlResolver.canResolveUrl(httpServletRequest);
                if (!bl) continue;
                uRL = iUploadUrlResolver.resolveUrl(httpServletRequest);
                break;
            }
        }
        if (!bl || uRL == null) {
            throw new MalformedURLException("The proxy URL cannot be resolved from URL: " + httpServletRequest.getRequestURL().toString());
        }
        return uRL;
    }

    protected void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        Object object2;
        String string;
        HttpsURLConnection httpsURLConnection;
        Object object3;
        URL uRL;
        try {
            uRL = this.resolveUrl(httpServletRequest);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            String string2 = "The URL is not correct: " + httpServletRequest.getRequestURL().toString();
            _logger.error((Object)exception);
            FileUploadRequestHandler.returnError(httpServletResponse, string2);
            return;
        }
        try {
            object3 = httpServletRequest.getParameter(VC_SERVICE_GUID_PARAM);
            Preconditions.checkArgument((!StringUtil.isNullOrEmpty((String)object3) ? 1 : 0) != 0);
            httpsURLConnection = FileUploadRequestHandler.createConnection(uRL, httpServletRequest, this.getSSLSocketFactory());
            string = VimSessionUtil.getService((String)object3).getConnectionInfo().getSessionCookie();
            httpsURLConnection.setRequestProperty("Cookie", "vmware_soap_session=" + string);
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException exception) {
            String string3 = "Failed to create connection to url: " + uRL;
            _logger.error((Object)string3, (Throwable)exception);
            FileUploadRequestHandler.returnError(httpServletResponse, string3);
            return;
        }
        object3 = new byte[this._bufferSizeInBytes];
        try {
            string = httpServletRequest.getInputStream();
            object2 = null;
            try {
                object = httpsURLConnection.getOutputStream();
                Throwable throwable = null;
                try {
                    int n = 0;
                    while ((n = ((InputStream)((Object)string)).read((byte[])object3)) > 0) {
                        ((OutputStream)object).write((byte[])object3, 0, n);
                        ((OutputStream)object).flush();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)object).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (string != null) {
                    if (object2 != null) {
                        try {
                            ((InputStream)((Object)string)).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)((Object)string)).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            String string4 = "Failed to transfer data to url: " + uRL;
            _logger.error((Object)string4, (Throwable)iOException);
            FileUploadRequestHandler.returnError(httpServletResponse, string4);
            return;
        }
        try {
            int n = httpsURLConnection.getResponseCode();
            if (n >= 200 && n < 300) {
                FileUploadRequestHandler.returnResponse(httpServletResponse, 200, "File uploaded successfully.");
            } else {
                object2 = httpsURLConnection.getResponseMessage();
                object = "HTTP connection to url: %s failed with status code: %s and response message: %s";
                _logger.error((Object)String.format((String)object, uRL, n, object2));
                FileUploadRequestHandler.returnError(httpServletResponse, (String)object2);
            }
        }
        catch (IOException iOException) {
            object2 = "Failed to get response from url: " + uRL;
            _logger.error(object2, (Throwable)iOException);
            FileUploadRequestHandler.returnError(httpServletResponse, (String)object2);
        }
    }

    private static void returnError(HttpServletResponse httpServletResponse, String string) throws IOException {
        FileUploadRequestHandler.returnResponse(httpServletResponse, 500, string);
    }

    private static void returnResponse(HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        httpServletResponse.setStatus(n);
        httpServletResponse.setContentType("text/plain");
        try (PrintWriter printWriter = httpServletResponse.getWriter();){
            printWriter.print(string);
        }
    }

    private static HttpsURLConnection createConnection(URL uRL, HttpServletRequest httpServletRequest, SSLSocketFactory sSLSocketFactory) throws IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
        httpsURLConnection.setRequestMethod(httpServletRequest.getMethod());
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestProperty("Content-Type", httpServletRequest.getContentType());
        long l = FileUploadRequestHandler.getContentLength(httpServletRequest);
        if (l > -1L) {
            httpsURLConnection.setRequestProperty("Content-Length", String.valueOf(l));
            httpsURLConnection.setFixedLengthStreamingMode(l);
        } else {
            httpsURLConnection.setChunkedStreamingMode(0x100000);
        }
        return httpsURLConnection;
    }

    private static long getContentLength(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("Content-Length");
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }
}

