/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http.transport.urlResolver;

import com.google.common.collect.ImmutableList;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.http.transport.urlResolver.IUploadUrlResolver;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreFileUploadUrlResolver
implements IUploadUrlResolver {
    private static final Log _logger = LogFactory.getLog(DatastoreFileUploadUrlResolver.class);
    private static final String DATACENTER = "datacenterId";
    private static final String DATASTORE = "datastoreId";
    private static final String DATASTORE_PATH = "datastorePath";
    public static final String FILE_UPLOAD_URLS = "datastoreFilesUrls";
    private final DataService _dataService;
    private final ObjectReferenceService _objectReferenceService;

    public DatastoreFileUploadUrlResolver(DataService dataService, ObjectReferenceService objectReferenceService) {
        this._dataService = dataService;
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    public URL resolveUrl(HttpServletRequest httpServletRequest) {
        URL uRL = null;
        String string = httpServletRequest.getParameter(DATACENTER);
        String string2 = httpServletRequest.getParameter(DATASTORE);
        String string3 = httpServletRequest.getParameter(DATASTORE_PATH);
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this._objectReferenceService.getReference(string);
        ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this._objectReferenceService.getReference(string2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(DATACENTER, managedObjectReference);
        hashMap.put(DATASTORE_PATH, new String[]{string3});
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.propertyName = FILE_UPLOAD_URLS;
        parameterSpec.parameter = hashMap;
        HashMap<String, ImmutableList> hashMap2 = new HashMap<String, ImmutableList>();
        hashMap2.put(FILE_UPLOAD_URLS, ImmutableList.of((Object)parameterSpec));
        try {
            String[] stringArray;
            PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object)managedObjectReference2, (String[])new String[]{FILE_UPLOAD_URLS}, hashMap2);
            if (propertyValueArray != null && propertyValueArray.length == 1 && propertyValueArray[0].value instanceof String[] && (stringArray = (String[])propertyValueArray[0].value) != null && stringArray.length == 1) {
                uRL = new URL(stringArray[0].toString());
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Datastore file upload URL cannot be resolved due to an exception.", (Throwable)exception);
        }
        return uRL;
    }

    @Override
    public boolean canResolveUrl(HttpServletRequest httpServletRequest) {
        boolean bl = !StringUtil.isNullOrEmpty((String)httpServletRequest.getParameter(DATACENTER)) && !StringUtil.isNullOrEmpty((String)httpServletRequest.getParameter(DATASTORE)) && !StringUtil.isNullOrEmpty((String)httpServletRequest.getParameter(DATASTORE_PATH));
        return bl;
    }
}

