/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.common.UnsupportedPropertyException;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.data.QueryDataUtil;
import com.vmware.vise.vim.i18n.VimServicesVsphereUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vise.vim.security.DisabledOperationsManager;
import com.vmware.vise.vim.security.accesscontrol.impl.AuthorizationServicePropertyAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisabledOperationsManagerImpl
implements DisabledOperationsManager,
PropertyProviderAdapter {
    private final DataService _dataService;
    private final ObjectReferenceService _objRefService;
    private final DataServiceExtensionRegistry _extensionRegistry;
    private static final String DISABLED_METHODS = "disabledMethod";
    private static final String DISABLED_OPERATIONS = "disabledOperations";
    private static final String[] MO_TYPES = new String[]{VmwareDistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualSwitch.class.getSimpleName(), Folder.class.getSimpleName(), Datacenter.class.getSimpleName(), ComputeResource.class.getSimpleName(), HostSystem.class.getSimpleName(), VirtualMachine.class.getSimpleName(), VirtualApp.class.getSimpleName(), ClusterComputeResource.class.getSimpleName(), ResourcePool.class.getSimpleName(), Network.class.getSimpleName(), DistributedVirtualPortgroup.class.getSimpleName(), Datastore.class.getSimpleName(), StoragePod.class.getSimpleName(), OpaqueNetwork.class.getSimpleName()};
    private static final Log _logger = LogFactory.getLog(DisabledOperationsManagerImpl.class);

    public DisabledOperationsManagerImpl(DataService dataService, DataServiceExtensionRegistry dataServiceExtensionRegistry, ObjectReferenceService objectReferenceService, AuthorizationServicePropertyAdapter authorizationServicePropertyAdapter) {
        this._dataService = dataService;
        this._objRefService = objectReferenceService;
        this._extensionRegistry = dataServiceExtensionRegistry;
    }

    public void initialize() {
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        Object[] objectArray = propertyRequestSpec.objects;
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        List<String> list = this.extractProperties(propertySpecArray);
        Map<String, ResultItem> map = this.createResultItemMap(objectArray, list);
        ResultSet resultSet = new ResultSet();
        resultSet.items = map.values().toArray(new ResultItem[0]);
        resultSet.totalMatchedObjectCount = resultSet.items.length;
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        Map<String, PropertyValue> map2 = null;
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (DISABLED_OPERATIONS.equals(string)) {
                try {
                    if (map2 == null) {
                        map2 = this.getDisabledOperationsInternal(objectArray);
                    }
                    this.updateResultItemMapWithPropertyValue(map, map2, i);
                }
                catch (Exception exception) {
                    arrayList.add(exception);
                }
                continue;
            }
            _logger.error((Object)("AuthorizationService called for an unsupported property - " + string));
            UnsupportedPropertyException unsupportedPropertyException = new UnsupportedPropertyException(VimServicesVsphereUtil.getLocalizedString("AuthService.unsupportedProperty"));
            arrayList.add((Exception)unsupportedPropertyException);
        }
        if (arrayList.size() > 0) {
            CompositeException compositeException = new CompositeException(arrayList);
            resultSet.error = compositeException;
            this.fixResultSetIfNeeded(resultSet);
        }
        return resultSet;
    }

    public boolean checkDisabledOperations(ManagedObjectReference[] managedObjectReferenceArray, String[] stringArray) throws Exception {
        PropertyValue[] propertyValueArray;
        if (managedObjectReferenceArray == null || stringArray == null) {
            return true;
        }
        for (PropertyValue propertyValue : propertyValueArray = this.getDisabledOperations(managedObjectReferenceArray)) {
            String[] stringArray2 = (String[])propertyValue.value;
            boolean bl = AuthorizationUtil.isOperationAllowed((String[])stringArray, (String[])stringArray2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    public PropertyValue[] getDisabledOperations(ManagedObjectReference[] managedObjectReferenceArray) throws Exception {
        Map<String, PropertyValue> map = this.getDisabledOperationsInternal(managedObjectReferenceArray);
        return map.values().toArray(new PropertyValue[0]);
    }

    public Map<String, PropertyValue> getDisabledOperationsInternal(Object[] objectArray) throws Exception {
        HashMap<String, PropertyValue> hashMap = new HashMap<String, PropertyValue>();
        if (objectArray == null) {
            return hashMap;
        }
        Map map = null;
        try {
            map = QueryDataUtil.getProperties((DataService)this._dataService, (Object[])objectArray, (String[])new String[]{DISABLED_METHODS});
        }
        catch (Exception exception) {
            _logger.error((Object)"Error fetching disabled methods.", (Throwable)exception);
        }
        for (Object object : objectArray) {
            String string = this._objRefService.getUid(object);
            if (map == null || map.get(string) == null) {
                _logger.info((Object)("Effective role was not fetched correctly for object - " + string));
                hashMap.put(string, this.newPropertyValue(object, DISABLED_OPERATIONS, new String[0]));
                continue;
            }
            List list = (List)map.get(string);
            ResultItem resultItem = (ResultItem)list.get(0);
            if (resultItem.properties.length == 0) {
                _logger.info((Object)("Disabled operations not fetched correctly for object - " + string));
                hashMap.put(string, this.newPropertyValue(object, DISABLED_OPERATIONS, new String[0]));
                continue;
            }
            String[] stringArray = resultItem.properties.length > 1 ? (String[])resultItem.properties[1].value : (String[])resultItem.properties[0].value;
            hashMap.put(string, this.newPropertyValue(object, DISABLED_OPERATIONS, stringArray));
        }
        return hashMap;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        for (String string : MO_TYPES) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = string;
            typeInfo.properties = new String[]{DISABLED_OPERATIONS};
            arrayList.add(typeInfo);
        }
        return arrayList.toArray(new TypeInfo[0]);
    }

    private List<String> extractProperties(PropertySpec[] propertySpecArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertySpec propertySpec : propertySpecArray) {
            arrayList.addAll(Arrays.asList(propertySpec.propertyNames));
        }
        return arrayList;
    }

    private Map<String, ResultItem> createResultItemMap(Object[] objectArray, List<String> list) {
        HashMap<String, ResultItem> hashMap = new HashMap<String, ResultItem>();
        for (Object object : objectArray) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = object;
            resultItem.properties = new PropertyValue[list.size()];
            String string = this._objRefService.getUid(object);
            hashMap.put(string, resultItem);
        }
        return hashMap;
    }

    private void updateResultItemMapWithPropertyValue(Map<String, ResultItem> map, Map<String, PropertyValue> map2, int n) {
        for (String string : map.keySet()) {
            PropertyValue propertyValue;
            ResultItem resultItem = map.get(string);
            resultItem.properties[n] = propertyValue = map2.get(string);
        }
    }

    private void fixResultSetIfNeeded(ResultSet resultSet) {
        if (ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            return;
        }
        for (ResultItem resultItem : resultSet.items) {
            if (ArrayUtil.isNullOrEmpty((Object[])resultItem.properties) || !this.isFixNeeded(resultItem.properties)) continue;
            ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
            for (PropertyValue propertyValue : resultItem.properties) {
                if (propertyValue == null) continue;
                arrayList.add(propertyValue);
            }
            resultItem.properties = (PropertyValue[])ArrayUtil.toArray(arrayList, PropertyValue.class);
        }
    }

    private boolean isFixNeeded(PropertyValue[] propertyValueArray) {
        for (PropertyValue propertyValue : propertyValueArray) {
            if (propertyValue != null) continue;
            return true;
        }
        return false;
    }

    private PropertyValue newPropertyValue(Object object, String string, Object object2) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = object;
        propertyValue.propertyName = string;
        propertyValue.value = object2;
        return propertyValue;
    }
}

