/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.impl;

import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.Description;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.i18n.VimServicesVsphereUtil;
import com.vmware.vise.vim.security.AuthorizationObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vise.vim.security.accesscontrol.impl.AuthorizationServicePropertyAdapter;
import com.vmware.vise.vim.security.data.PermissionData;
import com.vmware.vise.vim.security.data.PermissionInfo;
import com.vmware.vise.vim.security.data.PrivilegeData;
import com.vmware.vise.vim.security.data.PrivilegeInfo;
import com.vmware.vise.vim.security.data.RoleData;
import com.vmware.vise.vim.security.data.RoleProviderData;
import com.vmware.vise.vim.security.util.VCAuthorizationUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class LegacyAuthorizationServicePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(LegacyAuthorizationServicePropertyProvider.class);
    @Deprecated
    public static final String PRIVILEGE_INFO_SYNC = "PRIVILEGE_INFO_SYNC";
    @Deprecated
    public static final String PRIVILEGE_INFO = "PRIVILEGE_INFO";
    private final AuthorizationServicePropertyAdapter _authzPropAdapter;
    private final QueryExecutor _queryExecutor;

    public LegacyAuthorizationServicePropertyProvider(QueryExecutor queryExecutor, AuthorizationServicePropertyAdapter authorizationServicePropertyAdapter) {
        this._queryExecutor = queryExecutor;
        this._authzPropAdapter = authorizationServicePropertyAdapter;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod,OpaqueNetwork")
    public PrivilegeInfo getSystemPrivileges(ManagedObjectReference managedObjectReference) throws Exception {
        PrivilegeInfo privilegeInfo = new PrivilegeInfo();
        if (VCAuthorizationUtil.useLegacyPermissionsCheck(managedObjectReference)) {
            ArrayList arrayList = new ArrayList();
            PrivilegeData[] privilegeDataArray = null;
            AuthorizationManager.Privilege[] privilegeArray = this.getSystemPrivileges(managedObjectReference.getServerGuid());
            privilegeDataArray = new PrivilegeData[privilegeArray.length];
            int n = 0;
            Object object = privilegeArray;
            int n2 = ((AuthorizationManager.Privilege[])object).length;
            for (int i = 0; i < n2; ++i) {
                AuthorizationManager.Privilege privilege = object[i];
                AuthorizationUtil.addPrivilegeLocalizationKeys((String)privilege.privId, arrayList);
                String string = privilege.privGroupName;
                AuthorizationUtil.addGroupLocalizationKeys((String)string, arrayList);
                privilegeDataArray[n++] = this.createPrivilegeData(privilege);
            }
            privilegeInfo.properties = object = LocalizationUtil.getLocalizedMessage((String[])arrayList.toArray(new String[0]), (KeyAnyValue[][])null);
            privilegeInfo.privilegeData = privilegeDataArray;
        } else {
            privilegeInfo = this._authzPropAdapter.getSystemPrivileges(managedObjectReference);
        }
        return privilegeInfo;
    }

    private PrivilegeData createPrivilegeData(AuthorizationManager.Privilege privilege) {
        PrivilegeData privilegeData = new PrivilegeData();
        privilegeData.name = privilege.getName();
        privilegeData.onParent = privilege.isOnParent();
        privilegeData.description = null;
        privilegeData.id = privilege.getPrivId();
        privilegeData.group = privilege.getPrivGroupName();
        return privilegeData;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod,OpaqueNetwork")
    public RoleData[] getRolesInfo(ManagedObjectReference managedObjectReference) throws Exception {
        RoleData[] roleDataArray = null;
        if (VCAuthorizationUtil.useLegacyPermissionsCheck(managedObjectReference)) {
            AuthorizationManager.Role[] roleArray = VCAuthorizationUtil.getRoles(managedObjectReference.getServerGuid(), true);
            roleDataArray = new RoleData[roleArray.length];
            for (int i = 0; i < roleArray.length; ++i) {
                roleDataArray[i] = this.createRoleData(roleArray[i]);
            }
        } else {
            roleDataArray = this._authzPropAdapter.getRolesInfo(managedObjectReference);
        }
        return roleDataArray;
    }

    private RoleData createRoleData(AuthorizationManager.Role role) {
        RoleData roleData = new RoleData();
        roleData.id = Integer.toString(role.getRoleId());
        roleData.name = role.getName();
        roleData.system = role.isSystem();
        roleData.privilegeIds = role.getPrivilege();
        Description description = role.getInfo();
        if (description != null) {
            roleData.label = description.getLabel();
            roleData.summary = description.getSummary();
        } else {
            roleData.label = "";
            roleData.summary = "";
        }
        roleData.tenant = null;
        return roleData;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod,OpaqueNetwork")
    public PermissionInfo[] getEntityPermission(ManagedObjectReference managedObjectReference) throws Exception {
        PermissionInfo[] permissionInfoArray = null;
        if (VCAuthorizationUtil.useLegacyPermissionsCheck(managedObjectReference)) {
            AuthorizationManager.Permission[] permissionArray;
            ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
            VcService vcService = VimSessionUtil.getService((String)managedObjectReference.getServerGuid());
            AuthorizationManager authorizationManager = (AuthorizationManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vcService.getServiceInstanceContent().authorizationManager);
            for (AuthorizationManager.Permission permission : permissionArray = authorizationManager.retrieveEntityPermissions(managedObjectReference, true)) {
                PermissionInfo permissionInfo = this.getPermissionInfo(permission);
                arrayList.add(permissionInfo);
            }
            permissionInfoArray = (PermissionInfo[])ArrayUtil.toArray(arrayList, PermissionInfo.class);
        } else {
            permissionInfoArray = this._authzPropAdapter.getEntityPermission(managedObjectReference);
        }
        return permissionInfoArray;
    }

    private PermissionInfo getPermissionInfo(AuthorizationManager.Permission permission) {
        PermissionInfo permissionInfo = new PermissionInfo();
        PermissionData permissionData = VCAuthorizationUtil.toPermissionData(permission);
        try {
            AuthorizationManager.Role role = VCAuthorizationUtil.getRole(permission.roleId, permission.entity.getServerGuid());
            permissionInfo.label = role.info.label;
        }
        catch (Exception exception) {
            _logger.warn((Object)"Failed to retrieve role information:", (Throwable)exception);
        }
        permissionInfo.permission = permissionData;
        return permissionInfo;
    }

    @type(value="vsphere:vSphereClientInstance")
    public RoleProviderData[] getRoleProviders(URI uRI) {
        LinkedVcGroup[] linkedVcGroupArray;
        LinkedList<RoleProviderData> linkedList = new LinkedList<RoleProviderData>();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups()) {
            Collection collection = linkedVcGroup.getVcServices();
            for (VcService vcService : collection) {
                ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
                ManagedObjectReference managedObjectReference = serviceInstanceContent.rootFolder;
                RoleProviderData roleProviderData = new RoleProviderData();
                roleProviderData.label = VcServiceUtil.getServiceName((String)managedObjectReference.getServerGuid());
                roleProviderData.version = vcService.getServiceVersion();
                roleProviderData.provider = managedObjectReference;
                linkedList.add(roleProviderData);
            }
        }
        return linkedList.toArray(new RoleProviderData[linkedList.size()]);
    }

    private RoleProviderData getAuthzRoleProvider() {
        RoleProviderData roleProviderData = null;
        URI uRI = AuthorizationObjectUtil.ROOT_NODE_URI;
        try {
            Object[] objectArray = (String[])this._queryExecutor.getProperty((Object)uRI, "grantedPrivileges");
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                return null;
            }
            roleProviderData = new RoleProviderData();
            roleProviderData.label = VimServicesVsphereUtil.getLocalizedString("AuthzService.roleProvider");
            roleProviderData.provider = uRI;
        }
        catch (Exception exception) {
            return null;
        }
        return roleProviderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationManager.Privilege[] getSystemPrivileges(String string) throws Exception {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
        if (linkedVcGroup == null) {
            return new AuthorizationManager.Privilege[0];
        }
        VcService vcService = linkedVcGroup.getStartUpVcService();
        Object object = SessionUtil.getSyncObject((String)PRIVILEGE_INFO_SYNC, null);
        synchronized (object) {
            AuthorizationManager.Privilege[] privilegeArray;
            HashMap<String, AuthorizationManager.Privilege[]> hashMap = (HashMap<String, AuthorizationManager.Privilege[]>)SessionUtil.getData((String)PRIVILEGE_INFO);
            if (hashMap == null) {
                hashMap = new HashMap<String, AuthorizationManager.Privilege[]>();
                SessionUtil.setData((String)PRIVILEGE_INFO, hashMap);
            }
            if ((privilegeArray = (AuthorizationManager.Privilege[])hashMap.get(vcService.getServiceGuid())) != null) {
                return privilegeArray;
            }
            ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().getAuthorizationManager();
            AuthorizationManager authorizationManager = (AuthorizationManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            privilegeArray = authorizationManager.getPrivilegeList();
            hashMap.put(vcService.getServiceGuid(), privilegeArray);
            return privilegeArray;
        }
    }
}

