/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.util;

import com.vmware.cis.authz.PermissionTypes;
import com.vmware.cis.authz.Principal;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationService;
import com.vmware.vise.vim.security.data.PermissionData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCAuthorizationUtil {
    private static final Log _logger = LogFactory.getLog(VCAuthorizationUtil.class);
    @Deprecated
    public static final String ROLE_INFO = "ROLE_INFO";
    @Deprecated
    public static final String ROLE_INFO_SYNC = "ROLE_INFO_SYNC";
    private static final Version LEGACY_VERSION = new Version("5.5");
    private static final String PERMISSION_MODE_CACHE_KEY = "permission.mode.cache.key";
    private static final String PERMISSION_MODE_CONFIG_KEY = "permissions.mode";
    private static ConfigurationService configurationService;

    public static void setConfigurationService(ConfigurationService configurationService) {
        VCAuthorizationUtil.configurationService = configurationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static AuthorizationManager.Role[] getRoles(String string, boolean bl) throws Exception {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
        if (linkedVcGroup == null) {
            return new AuthorizationManager.Role[0];
        }
        String string2 = linkedVcGroup.getStartUpVcService().getServiceGuid();
        Object object = SessionUtil.getSyncObject((String)ROLE_INFO_SYNC, null);
        synchronized (object) {
            HashMap<String, AuthorizationManager.Role[]> hashMap = (HashMap<String, AuthorizationManager.Role[]>)SessionUtil.getData((String)ROLE_INFO);
            if (hashMap == null) {
                hashMap = new HashMap<String, AuthorizationManager.Role[]>();
                SessionUtil.setData((String)ROLE_INFO, hashMap);
            }
            boolean bl2 = !bl;
            AuthorizationManager.Role[] roleArray = (AuthorizationManager.Role[])hashMap.get(string2);
            if (roleArray != null && bl2) {
                _logger.debug((Object)("Returning role data from cache for: " + string));
                return roleArray;
            }
            roleArray = VCAuthorizationUtil.getRolesFromVC(linkedVcGroup);
            hashMap.put(string2, roleArray);
            return roleArray;
        }
    }

    @Deprecated
    private static AuthorizationManager.Role[] getRolesFromVC(LinkedVcGroup linkedVcGroup) throws Exception {
        VcService vcService = linkedVcGroup.getStartUpVcService();
        ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().getAuthorizationManager();
        _logger.debug((Object)("Fetching role data from VC: " + managedObjectReference.getServerGuid()));
        AuthorizationManager authorizationManager = (AuthorizationManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        AuthorizationManager.Role[] roleArray = authorizationManager.getRoleList();
        return roleArray;
    }

    @Deprecated
    public static AuthorizationManager.Role getRole(Integer n, String string) throws Exception {
        AuthorizationManager.Role[] roleArray;
        for (AuthorizationManager.Role role : roleArray = VCAuthorizationUtil.getRoles(string, false)) {
            if (n != role.roleId) continue;
            return role;
        }
        return null;
    }

    public static AuthorizationManager getAuthorizationManager(String string) throws Exception {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
        VcService vcService = linkedVcGroup.getVcService(string);
        ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().getAuthorizationManager();
        AuthorizationManager authorizationManager = (AuthorizationManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        return authorizationManager;
    }

    private static String getVersion(String string) {
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            return null;
        }
        ServiceInstance serviceInstance = vcService.getServiceInstance();
        ServiceInstanceContent serviceInstanceContent = serviceInstance.getContent();
        AboutInfo aboutInfo = serviceInstanceContent.getAbout();
        return aboutInfo.getVersion();
    }

    private static PermissionMode getPermissionMode() {
        String string = configurationService.getProperty(PERMISSION_MODE_CONFIG_KEY);
        try {
            PermissionMode permissionMode = Enum.valueOf(PermissionMode.class, string);
            return permissionMode;
        }
        catch (Exception exception) {
            _logger.info((Object)String.format("Parsing %s failed: %s. Using default value.", PERMISSION_MODE_CONFIG_KEY, exception.getMessage()));
            return PermissionMode.auto;
        }
    }

    public static boolean useLegacyPermissionsCheck(Object object) {
        if (!(object instanceof ManagedObjectReference)) {
            return false;
        }
        String string = ((ManagedObjectReference)object).getServerGuid();
        ConcurrentHashMap<String, Boolean> concurrentHashMap = (ConcurrentHashMap<String, Boolean>)SessionUtil.getData((String)PERMISSION_MODE_CACHE_KEY);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap<String, Boolean>();
            SessionUtil.setData((String)PERMISSION_MODE_CACHE_KEY, concurrentHashMap);
        } else if (concurrentHashMap.containsKey(string)) {
            boolean bl = (Boolean)concurrentHashMap.get(string);
            if (_logger.isDebugEnabled()) {
                String string2 = String.format("(cached setting) Server with GUID '?' uses ? permission checking mode", string, bl ? "Legacy" : "AuthZ");
                _logger.debug((Object)string2);
            }
            return bl;
        }
        PermissionMode permissionMode = VCAuthorizationUtil.getPermissionMode();
        if (PermissionMode.legacy.equals((Object)permissionMode)) {
            _logger.info((Object)("Forced Legacy/VC permission mode for server with GUID '" + string + "'"));
            concurrentHashMap.put(string, Boolean.TRUE);
            return true;
        }
        if (PermissionMode.authz.equals((Object)permissionMode)) {
            _logger.info((Object)("Forced AuthZ permission mode for server with GUID '" + string + "'"));
            concurrentHashMap.put(string, Boolean.FALSE);
            return false;
        }
        String string3 = VCAuthorizationUtil.getVersion(string);
        _logger.info((Object)("Server " + string + " version detected: " + string3));
        Version version = new Version(string3);
        if (version.compareTo(LEGACY_VERSION) <= 0) {
            _logger.info((Object)("Assuming Legacy/VC permission for server with GUID '" + string + "'"));
            concurrentHashMap.put(string, Boolean.TRUE);
            return true;
        }
        if (!VCAuthorizationUtil.isStartupLinkedVCGroup(string)) {
            _logger.info((Object)("Assuming Legacy/VC permission for server with GUID '" + string + "' on the account it is a remote VC server"));
            concurrentHashMap.put(string, Boolean.TRUE);
            return true;
        }
        _logger.info((Object)("Assuming AuthZ permission for server with GUID '" + string + "'"));
        concurrentHashMap.put(string, Boolean.FALSE);
        return false;
    }

    private static boolean isStartupLinkedVCGroup(String string) {
        HttpSession httpSession = SessionUtil.getHttpSession();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)httpSession);
        LinkedVcGroupRegistry.StartupGroupUtils startupGroupUtils = linkedVcGroupRegistry.getUtils();
        for (LinkedVcGroup linkedVcGroup : startupGroupUtils.getStartupLinkedVcGroups()) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (!vcService.getServiceGuid().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static AuthorizationManager.Permission toPermission(PermissionData permissionData) {
        AuthorizationManager.Permission permission = new AuthorizationManager.Permission();
        permission.entity = (ManagedObjectReference)permissionData.entity;
        permission.principal = permissionData.principal;
        permission.group = permissionData.group;
        permission.roleId = Integer.parseInt(permissionData.roleId);
        permission.propagate = permissionData.propagate;
        return permission;
    }

    public static AuthorizationManager.Permission[] toPermissions(PermissionData[] permissionDataArray) {
        ArrayList<AuthorizationManager.Permission> arrayList = new ArrayList<AuthorizationManager.Permission>();
        for (PermissionData permissionData : (PermissionData[])ArrayUtil.toSafe((Object[])permissionDataArray, PermissionData.class)) {
            AuthorizationManager.Permission permission = VCAuthorizationUtil.toPermission(permissionData);
            arrayList.add(permission);
        }
        return (AuthorizationManager.Permission[])ArrayUtil.toArray(arrayList, AuthorizationManager.Permission.class);
    }

    public static PermissionData[] toPermissionData(AuthorizationManager.Permission[] permissionArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])permissionArray)) {
            return new PermissionData[0];
        }
        PermissionData[] permissionDataArray = new PermissionData[permissionArray.length];
        for (int i = 0; i < permissionArray.length; ++i) {
            AuthorizationManager.Permission permission = permissionArray[i];
            permissionDataArray[i] = VCAuthorizationUtil.toPermissionData(permission);
        }
        return permissionDataArray;
    }

    public static PermissionData toPermissionData(AuthorizationManager.Permission permission) {
        PermissionData permissionData = new PermissionData();
        permissionData.id = null;
        permissionData.entity = permission.entity;
        permissionData.principal = permission.principal;
        permissionData.group = permission.group;
        permissionData.roleId = Integer.toString(permission.roleId);
        permissionData.propagate = permission.propagate;
        return permissionData;
    }

    public static PermissionData toPermissionData(PermissionTypes.Info info, AuthorizationService authorizationService) {
        PermissionData permissionData = new PermissionData();
        permissionData.id = info.getId();
        permissionData.entity = authorizationService.getReference(info.getResourceId());
        Principal.Type type = info.getPrincipal().getType();
        if (type == Principal.Type.USER) {
            permissionData.principal = info.getPrincipal().getUserName();
            permissionData.group = false;
        } else if (type == Principal.Type.GROUP) {
            permissionData.principal = info.getPrincipal().getGroupName();
            permissionData.group = true;
        }
        if (ArrayUtil.isNullOrEmpty((List)info.getRoleId())) {
            _logger.warn((Object)String.format("roleId for permission: \"%s\" is null or empty", info.toString()));
        } else {
            permissionData.roleId = (String)info.getRoleId().get(0);
        }
        permissionData.propagate = info.getPropagate();
        return permissionData;
    }

    public static PermissionTypes.Info toVapiPermission(PermissionData permissionData) {
        PermissionTypes.Info info = new PermissionTypes.Info();
        info.setPrincipal(VCAuthorizationUtil.getPrincipal(permissionData));
        info.setPropagate(permissionData.propagate);
        info.setRoleId(Arrays.asList(permissionData.roleId));
        return info;
    }

    public static Principal getPrincipal(PermissionData permissionData) {
        Principal principal = new Principal();
        if (permissionData.group) {
            principal.setGroupName(permissionData.principal);
            principal.setType(Principal.Type.GROUP);
        } else {
            principal.setUserName(permissionData.principal);
            principal.setType(Principal.Type.USER);
        }
        return principal;
    }

    private static enum PermissionMode {
        auto,
        legacy,
        authz;

    }
}

