/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vcservice;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CompatibilityUtil {
    private static final Log _logger = LogFactory.getLog(CompatibilityUtil.class);
    private static final String SUPPORTED_SERVER_VERSIONS_KEY = "supportedServerVersions";
    private static final String CLIENT_PACKAGE_ID = "com.vmware.vsphere.client";
    private static final String SUPPORTED_VERSION_DELIMITER = ",";

    CompatibilityUtil() {
    }

    static PluginPackageInfo getPluginPackageInfo(ExtensionService extensionService) {
        try {
            PluginPackageInfo[] pluginPackageInfoArray;
            for (PluginPackageInfo pluginPackageInfo : pluginPackageInfoArray = extensionService.getPluginPackageInfos()) {
                if (!pluginPackageInfo.getId().equals(CLIENT_PACKAGE_ID)) continue;
                return pluginPackageInfo;
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when fetching plugin packages", (Throwable)exception);
        }
        return null;
    }

    static String[] getSupportedServerVersions(PluginPackageInfo pluginPackageInfo) {
        if (pluginPackageInfo == null) {
            return null;
        }
        Map map = pluginPackageInfo.getMetadata();
        if (map == null || !map.containsKey(SUPPORTED_SERVER_VERSIONS_KEY)) {
            return null;
        }
        String string = (String)map.get(SUPPORTED_SERVER_VERSIONS_KEY);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        return string.split(SUPPORTED_VERSION_DELIMITER);
    }

    @Deprecated
    static boolean isSupportedVersion(String[] stringArray, String string) {
        return Version.isSupportedVersion((String[])stringArray, (String)string);
    }
}

