/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.groups.impl;

import com.vmware.vim.binding.vim.cluster.FtVmHostRuleInfo;
import com.vmware.vim.binding.vim.cluster.GroupInfo;
import com.vmware.vim.binding.vim.cluster.GroupSpec;
import com.vmware.vim.binding.vim.cluster.HostGroup;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.cluster.VmGroup;
import com.vmware.vim.binding.vim.cluster.VmHostRuleInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.cluster.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupSpecValidator {
    private static Log _logger = LogFactory.getLog(GroupSpecValidator.class);
    private static final int MAX_GROUP_NAME_LENGTH = 80;
    private final DataService _dataService;
    private final ManagedObjectReference _clusterRef;
    private final GroupSpec _groupSpec;

    public GroupSpecValidator(DataService dataService, ManagedObjectReference clusterRef, GroupSpec groupSpec) {
        this._dataService = dataService;
        this._clusterRef = clusterRef;
        this._groupSpec = groupSpec;
    }

    public ValidationResult checkName() {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = this._clusterRef;
        try {
            if (this._groupSpec == null || this._groupSpec.info == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.validation.noGroupValidationSpec"));
            }
            if (StringUtil.isNullOrEmpty((String)this._groupSpec.info.name)) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.validation.nameEmpty"));
            }
            if (this._groupSpec.info.name.length() > 80) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.validation.nameTooLong"));
            }
            GroupInfo[] clusterGroups = (GroupInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)this._clusterRef, (String)"configurationEx[@type='ClusterConfigInfoEx'].group");
            Boolean isNameUnique = true;
            for (GroupInfo group : clusterGroups) {
                if (!group.name.equals(this._groupSpec.info.name)) continue;
                isNameUnique = false;
                break;
            }
            validationResult.result = isNameUnique;
        }
        catch (Exception e) {
            _logger.error((Object)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    public ValidationResult checkIfGroupIsInUse() {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = this._clusterRef;
        try {
            if (this._groupSpec == null || this._groupSpec.info == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.validation.noGroupValidationSpec"));
            }
            Boolean isGroupInUse = false;
            RuleInfo[] clusterRules = (RuleInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)this._clusterRef, (String)"configurationEx[@type='ClusterConfigInfoEx'].rule");
            String groupName = this._groupSpec.info.name;
            if (this._groupSpec.info instanceof VmGroup) {
                isGroupInUse = this.containsVmGroup(clusterRules, groupName);
            } else if (this._groupSpec.info instanceof HostGroup) {
                isGroupInUse = this.containsHostGroup(clusterRules, groupName);
            }
            validationResult.result = isGroupInUse;
        }
        catch (Exception e) {
            _logger.error((Object)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    private Boolean containsVmGroup(RuleInfo[] clusterRules, String groupName) {
        Boolean containsGroup = false;
        for (RuleInfo rule : clusterRules) {
            String vmGroupName = this.getVmGroupName(rule);
            if (!groupName.equals(vmGroupName)) continue;
            containsGroup = true;
            break;
        }
        return containsGroup;
    }

    private Boolean containsHostGroup(RuleInfo[] clusterRules, String groupName) {
        Boolean containsGroup = false;
        block0: for (RuleInfo rule : clusterRules) {
            String[] hostGroupNames;
            for (String name : hostGroupNames = this.getHostGroupNames(rule)) {
                if (!groupName.equals(name)) continue;
                containsGroup = true;
                continue block0;
            }
        }
        return containsGroup;
    }

    private String[] getHostGroupNames(RuleInfo rule) {
        ArrayList<String> hostGroupNames = new ArrayList<String>();
        if (rule instanceof VmHostRuleInfo) {
            VmHostRuleInfo vmHostRule = (VmHostRuleInfo)rule;
            hostGroupNames.add(vmHostRule.affineHostGroupName);
            hostGroupNames.add(vmHostRule.antiAffineHostGroupName);
        } else if (rule instanceof FtVmHostRuleInfo) {
            FtVmHostRuleInfo ftVmHostRule = (FtVmHostRuleInfo)rule;
            Collections.addAll(hostGroupNames, ftVmHostRule.hostGroupName);
        }
        return hostGroupNames.toArray(new String[hostGroupNames.size()]);
    }

    private String getVmGroupName(RuleInfo rule) {
        String vmGroupName = null;
        if (rule instanceof VmHostRuleInfo) {
            VmHostRuleInfo vmHostRule = (VmHostRuleInfo)rule;
            vmGroupName = vmHostRule.vmGroupName;
        } else if (rule instanceof FtVmHostRuleInfo) {
            FtVmHostRuleInfo ftVmHostRule = (FtVmHostRuleInfo)rule;
            vmGroupName = ftVmHostRule.primaryVmGroupName;
        }
        return vmGroupName;
    }
}

