/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.cluster.Action;
import com.vmware.vim.binding.vim.cluster.EVCManager;
import com.vmware.vim.binding.vim.cluster.GroupSpec;
import com.vmware.vim.binding.vim.cluster.InitialPlacementAction;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vim.cluster.RuleSpec;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.cluster.ClusterComputeResourceSpec;
import com.vmware.vsphere.client.cluster.ClusterEvcSpec;
import com.vmware.vsphere.client.cluster.groups.impl.GroupSpecValidator;
import com.vmware.vsphere.client.cluster.ha.proactive.FilterModel;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.FilterManager;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.InfraHelper;
import com.vmware.vsphere.client.cluster.rp.MorTree;
import com.vmware.vsphere.client.cluster.rp.RestoreRpTreeSpec;
import com.vmware.vsphere.client.cluster.rp.RestoreRpTreeValidationResult;
import com.vmware.vsphere.client.cluster.rp.RestoreRpTreeValidator;
import com.vmware.vsphere.client.cluster.rp.RpInfo;
import com.vmware.vsphere.client.cluster.rp.RpTreeSerDes;
import com.vmware.vsphere.client.cluster.rp.RpTreeSnapshotter;
import com.vmware.vsphere.client.cluster.rules.impl.ClusterRuleSpecValidator;
import com.vmware.vsphere.client.cluster.services.recommendations.ClusterRecommendationSpec;
import com.vmware.vsphere.client.cluster.services.recommendations.ClusterRecommendationSpecOperation;
import com.vmware.vsphere.client.cluster.util.Util;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterMutationProvider
implements MutationProvider {
    private static final String HOST_FOLDER_PROPERTY_NAME = "hostFolder";
    private static final Log _logger = LogFactory.getLog(ClusterMutationProvider.class);
    private final DataService _dataService;
    private final TaskMonitor _taskMonitor;
    private final LegacyAuthorizationService _authorizationService;

    public ClusterMutationProvider(DataService dataService, TaskMonitor taskMonitor, LegacyAuthorizationService authorizationService) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._authorizationService = authorizationService;
    }

    public OperationResult add(ClusterComputeResourceSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = spec.parent;
        try {
            Folder hostFolder;
            if (spec == null || spec.parent == null) {
                throw new IllegalArgumentException("No parent specified for the cluster to add.");
            }
            if (Datacenter.class.getSimpleName().equals(spec.parent.getType())) {
                ManagedObjectReference hfMoref = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)spec.parent, (String)HOST_FOLDER_PROPERTY_NAME);
                if (hfMoref == null) {
                    throw new Exception(Util.getLocalizedString("cluster.error.parent.dc.deleted"));
                }
                hostFolder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hfMoref);
            } else if (Folder.class.getSimpleName().equals(spec.parent.getType())) {
                hostFolder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.parent);
            } else {
                throw new IllegalArgumentException("Unexpected parent type provided.");
            }
            boolean isVsanSupported = VcServiceUtil.isOPVcOrLater((String)hostFolder._getRef().getServerGuid());
            if (!isVsanSupported) {
                spec.configSpecEx.vsanConfig = null;
                spec.configSpecEx.vsanHostConfigSpec = null;
            }
            ManagedObjectReference newCluster = hostFolder.createClusterEx(spec.name, spec.configSpecEx);
            result.result = newCluster;
            if (spec.evcModeKey != null) {
                ClusterComputeResource newClusterObj = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)newCluster);
                EVCManager evcManager = (EVCManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)newClusterObj.evcManager());
                ManagedObjectReference reconfigureTask = evcManager.configureEvc(spec.evcModeKey);
                TaskInfo reconfigureTaskInfo = this._taskMonitor.monitorTask(reconfigureTask);
                if (reconfigureTaskInfo.error != null) {
                    result.error = reconfigureTaskInfo.error;
                    _logger.error((Object)"Error for configureEVC task.", (Throwable)reconfigureTaskInfo.error);
                }
            }
            QueryUtil.waitUntilSearchable((DataService)this._dataService, (Object)newCluster, (String[])new String[]{"parent"});
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not create new cluster compute resource.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, Recommendation rec) {
        OperationResult result = new OperationResult();
        ArrayList<ManagedObjectReference> affectedVms = new ArrayList<ManagedObjectReference>();
        result.entity = clusterRef;
        Action[] acts = rec.action;
        if (acts != null) {
            for (Action action : acts) {
                if (!(action instanceof InitialPlacementAction)) continue;
                affectedVms.add(action.target);
            }
        }
        if (!affectedVms.isEmpty()) {
            result.effect = OperationEffect.newDelayedEffect();
            result.effect.affectedEntites = affectedVms.toArray(new ManagedObjectReference[affectedVms.size()]);
        }
        try {
            ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
            cluster.applyRecommendation(rec.key);
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, FilterModel filter) {
        assert (clusterRef != null);
        assert (filter != null);
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        try {
            InfraHelper infraHelper = new InfraHelper(clusterRef);
            infraHelper.initialize();
            FilterManager manager = new FilterManager(infraHelper);
            manager.reset().setProvider(filter.providerId).applyFilter(filter);
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception during Applying filter" + ex));
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, ClusterComputeResourceSpec spec) {
        assert (clusterRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        try {
            ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
            result.task = cluster.reconfigureEx((ComputeResource.ConfigSpec)spec.configSpecEx, spec.modify);
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot reconfigure cluster.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult applyDeferred(ManagedObjectReference clusterRef, ClusterComputeResourceSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        OperationResult result = new OperationResult();
        ManagedObjectReference schTaskRef = null;
        try {
            schTaskRef = scheduleSpec.scheduledTask != null ? this.editScheduleTaskForEditDrsConfig(clusterRef, spec, scheduleSpec) : this.createScheduleTaskForEditDrsConfig(clusterRef, spec, scheduleSpec);
            result.entity = schTaskRef;
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not update the scheduled task for Edit DRS", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, ClusterRecommendationSpec recommendationSpec) {
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        try {
            if (recommendationSpec.operation != ClusterRecommendationSpecOperation.refresh && (recommendationSpec.keys == null || recommendationSpec.keys.length == 0)) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.clusterRecommSpecInvalid"));
            }
            ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
            switch (recommendationSpec.operation) {
                case apply: {
                    for (String key : recommendationSpec.keys) {
                        cluster.applyRecommendation(key);
                    }
                    break;
                }
                case cancel: {
                    for (String key : recommendationSpec.keys) {
                        cluster.cancelRecommendation(key);
                    }
                    break;
                }
                case refresh: {
                    cluster.refreshRecommendation();
                    break;
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)String.format("Cannot execute cluster's recommendation related operation: %s", recommendationSpec.operation.toString()), (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference clusterRef, GroupSpec groupSpec) {
        ValidationResult result;
        GroupSpecValidator validator = new GroupSpecValidator(this._dataService, clusterRef, groupSpec);
        switch (groupSpec.operation) {
            case add: {
                result = validator.checkName();
                break;
            }
            case remove: {
                result = validator.checkIfGroupIsInUse();
                break;
            }
            default: {
                result = new ValidationResult();
                _logger.error((Object)"Validation called for unexpected cluster group operation.");
            }
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference clusterRef, ClusterEvcSpec spec) {
        ValidationResult result = new ValidationResult();
        result.entity = clusterRef;
        try {
            if (clusterRef == null || spec == null || spec.evcModeKey == null) {
                throw new Exception("Cannot validate without cluster ref or with null spec or with null evc mode key.");
            }
            ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
            EVCManager evcManager = (EVCManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cluster.evcManager());
            ManagedObjectReference task = evcManager.checkConfigureEvc(spec.evcModeKey);
            TaskInfo checkTaskInfo = this._taskMonitor.monitorTask(task);
            if (checkTaskInfo.error != null) {
                result.error = checkTaskInfo.error;
                _logger.error((Object)"Error for checkConfigureEVC task.", (Throwable)checkTaskInfo.error);
                return result;
            }
            result.result = checkTaskInfo.result;
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot validate cluster evc.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, ClusterEvcSpec spec) {
        assert (clusterRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        try {
            if (clusterRef == null || spec == null) {
                throw new Exception("Cannot reconfigure with null spec.");
            }
            ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
            EVCManager evcManager = (EVCManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cluster.evcManager());
            ManagedObjectReference reconfigureTask = spec.evcModeKey == null ? evcManager.disableEvc() : evcManager.configureEvc(spec.evcModeKey);
            TaskInfo checkTaskInfo = this._taskMonitor.monitorTask(reconfigureTask);
            if (checkTaskInfo.error != null) {
                result.error = checkTaskInfo.error;
                _logger.error((Object)"Error for disableEVC/configureEVC task.", (Throwable)checkTaskInfo.error);
            } else {
                result.result = checkTaskInfo.result;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot reconfigure cluster evc mode.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference clusterRef, RuleSpec ruleSpec) {
        ClusterRuleSpecValidator validator = new ClusterRuleSpecValidator(this._dataService, clusterRef, ruleSpec);
        ValidationResult result = validator.validateRuleSpec();
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, RestoreRpTreeSpec spec) {
        boolean deserializationSucceded;
        ValidationUtil.paramsNotNull((Object[])new Object[]{clusterRef, spec});
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        MorTree<ManagedObjectReference, RpInfo> rpTree = null;
        try {
            rpTree = this.deserializeRpTree(spec);
        }
        catch (Exception e) {
            _logger.error((Object)"Error occured during deserialization of cluster rp tree", (Throwable)e);
            Exception localizedEx = new Exception(Util.getLocalizedString("rp.error.deserialization"), e);
            result.error = MixedUtil.getMethodFault((Throwable)localizedEx);
        }
        boolean bl = deserializationSucceded = result.error == null;
        if (deserializationSucceded) {
            DataFetchCommand dataFetchCommand = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
            RpTreeSnapshotter rpTreeSnapshotter = new RpTreeSnapshotter(dataFetchCommand);
            try {
                rpTreeSnapshotter.restoreRpTree(rpTree);
            }
            catch (MethodFault fault) {
                _logger.error((Object)"VC fault occured during restore of cluster rp tree", (Throwable)fault);
                result.error = fault;
            }
            catch (RuntimeFault fault) {
                _logger.error((Object)"VC fault occured during restore of cluster rp tree", (Throwable)fault);
                result.error = MixedUtil.getMethodFault((Throwable)fault);
            }
            catch (Exception e) {
                _logger.error((Object)"Error occured during restore of cluster rp tree", (Throwable)e);
                Exception localizedEx = new Exception(Util.getLocalizedString("rp.error.restore.rpTree"), e);
                result.error = MixedUtil.getMethodFault((Throwable)localizedEx);
            }
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference clusterRef, RestoreRpTreeSpec spec) {
        boolean deserializationSucceded;
        ValidationUtil.paramsNotNull((Object[])new Object[]{clusterRef, spec});
        MorTree<ManagedObjectReference, RpInfo> rpTree = null;
        RestoreRpTreeValidationResult validationResult = null;
        MethodFault error = null;
        try {
            rpTree = this.deserializeRpTree(spec);
        }
        catch (Exception e) {
            _logger.error((Object)"Error occured during deserialization of cluster rp tree", (Throwable)e);
            validationResult = new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.DESERIALIZATION_ERROR);
        }
        boolean bl = deserializationSucceded = validationResult == null;
        if (deserializationSucceded) {
            DataFetchCommand dataFetchCommand = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
            RestoreRpTreeValidator validator = new RestoreRpTreeValidator(clusterRef, rpTree, dataFetchCommand, this._authorizationService);
            try {
                validationResult = validator.validate();
            }
            catch (Exception e) {
                _logger.error((Object)"Error occured during validation of cluster rp tree", (Throwable)e);
                Exception localizedEx = new Exception(Util.getLocalizedString("rp.error.validation"), e);
                error = MixedUtil.getMethodFault((Throwable)localizedEx);
            }
        }
        ValidationResult result = new ValidationResult();
        result.entity = clusterRef;
        result.result = validationResult;
        result.error = error;
        return result;
    }

    private ManagedObjectReference createScheduleTaskForEditDrsConfig(ManagedObjectReference clusterRef, ClusterComputeResourceSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = this.createDrsConfigScheduledTaskSpec(clusterRef, spec, scheduleSpec);
        return SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)clusterRef, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ManagedObjectReference editScheduleTaskForEditDrsConfig(ManagedObjectReference clusterRef, ClusterComputeResourceSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = this.createDrsConfigScheduledTaskSpec(clusterRef, spec, scheduleSpec);
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec);
    }

    private MorTree<ManagedObjectReference, RpInfo> deserializeRpTree(RestoreRpTreeSpec spec) throws Exception {
        RpTreeSerDes rpTreeSerDes = new RpTreeSerDes();
        MorTree<ManagedObjectReference, RpInfo> rpTree = rpTreeSerDes.deserialize(spec.rpTreeSnapshot);
        return rpTree;
    }

    private ScheduledTaskSpec createDrsConfigScheduledTaskSpec(ManagedObjectReference clusterRef, ClusterComputeResourceSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        MethodAction action = SchedulingUtil.newMethodAction((String)Util.CLUSTER_RECONFIGURE_TASK_NAME, (Object[])new Object[]{spec.configSpecEx, spec.modify});
        vcTaskSpec.action = action;
        return vcTaskSpec;
    }
}

