/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.sso.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "AuthenticationToken")
public class Token {
    public static final int TOKEN_TTL_MS = 3600000; // 1 hour

    private String authToken;
    private long expiration;

    public Token() {
        expiration = System.currentTimeMillis() + TOKEN_TTL_MS;
    }

    @XmlElement
    public String getAuthToken() {
        return authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    @XmlElement
    public long getExpiration() {
        return expiration;
    }
}
