/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.utils.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestHelper {
    public static String getHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                builder.append("0");
            }
            builder.append(hex);
        }
        return builder.toString();
    }

    private static String getChecksum(MessageDigest digest, String data) {
        byte[] bytes = digest.digest(data.getBytes());
        return getHex(bytes);
    }

    private static String getChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fileStream = null;
        BufferedInputStream bufferedStream = null;
        DigestInputStream digestStream = null;
        try {
            fileStream = new FileInputStream(file);
            bufferedStream = new BufferedInputStream(fileStream);
            digestStream = new DigestInputStream(bufferedStream, digest);
            while (digestStream.read() != -1)
                ;
            byte[] bytes = digest.digest();
            return getHex(bytes);
        } finally {
            if (digestStream != null) {
                digestStream.close();
            }
        }
    }

    public static String getMd5(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        return getChecksum(digest, data);
    }

    public static String getMd5(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        return getChecksum(digest, file);
    }

    public static String getSha256(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return getChecksum(digest, data);
    }

    public static String getSha256(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return getChecksum(digest, file);
    }
}
