/***********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.chart;

import com.vmware.vide.vlogbrowser.core.model.FilterList;


/**
 * This class specify that: In order to create a chart, it is necessary to have 3
 * things. First, a list of log items ordered by date. Second, a list of
 * filtered items. And third, an unique name that will identify the log file.
 *
 * @author Nilmax Moura
 *
 */
public interface ILogFile {

    /**
     * @return List of log item that was filtered by the user
     */
    public FilterList getFilterList();

    /**
     * @return Unique name that identify the log file
     */
    public String getName();

}
