/***********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.chart;

import java.util.Date;

/**
 * This interface defines the information that need to be available when a
 * user select a point in the Chart.
 *
 * @author Nilmax Moura
 *
 */
public interface ILogItemListener {

    /**
     * This method will be called when the user click on a point on the graph.
     * So, this method will provide the log file and the date associated
     * with that point selected by the user.
     *
     * @param logFile
     * @param logDate
     */
    public void mouseClicked(ILogFile logFile, Date date);

}
