/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.consts;

import com.vmware.vide.vlogbrowser.core.utils.Preferences;

public class LogBrowserConsts {
    public static final String ESX = "ESX";
    public static final String ESXi = "ESXi";
    public static final String VC_LINUX = "vc-linux";
    public static final String VC_WINDOWS = "vc-windows";
    public static final String LOCALHOST = "Local Filesystem";
    public static final String LINUX_SSH = "Linux SSH";
    public static final String HOST_ERROR = "Error contacting host";
    public static final String LOGX_FILE_EXTENSION = ".logx";
    public static final String PUBLIC_FOLDER_DIR = "/public/";
    public static final String LINUX_WORKSPACE_LOCATION = "/storage/log/vmware/vsphere-client";

    /**
     * Operators that connect the filter items in the Filtering dialog
     */
    public static enum BooleanConnector {
        AND, OR, SKIP
    }

    public static final int DEFAULT_COLUMN_COUNT = 2;

    public static final String[] ADD_LINES_VALUES = { "0", "1", "2", "3", "4", "5", "6", "7",
            "8", "9", "10" };

    public static final int MAX_NUM_ADD_LINES = ADD_LINES_VALUES.length - 1;

    public static final String REGULAR_EXP_MSG_PREAMBLE = "(Regular Expression: ";

    public static final String LOG_FORMAT_STD_PKG = "[Standard Log Package]";
    public static final String LOG_FORMAT_VMSUPPORT_ARCHIVE = "[vm-support Log Package]";
    public static final String LOG_FORMAT_VMSUPPORT_ARCHIVE_PATTERN = "(.+\\.tgz$)|(.+\\.zip$)";
    public static final String LOGBROWSER_PREF_DIR_ = "LOGBROWSER_PREF_DIR_";

    // The .logx "templates" directory (system-supplied, within the <vLogBrowser>.jar file)
    public static final String TEMPLATE_DIR = "/templates/";

    public static final String CACHE_DIR = getPlatformDirectory() + "/cache";

    /** Return the parent directory for the cache directory */
    private static String getPlatformDirectory() {
//        IWorkspace ws = ResourcesPlugin.getWorkspace();
//        IWorkspaceRoot root = ws.getRoot();
//        IPath path = root.getLocation();
//        String workspacePath = path.toOSString();
        String rootDir = Preferences.getInstance().getProperty(Preferences.ROOT_DIR);
        return rootDir + "/.vmwb/LogBrowser";
    }
}
