package com.vmware.vide.vlogbrowser.core.model;

import java.io.IOException;
import java.util.Comparator;

public interface ILogItemList {

    /** Add a LogItem element to the list */
    public boolean add(LogItem logItem);

    /** Appends all of the LogItem elements in the specified parameter to the end of this list */
    public boolean addAll(ILogItemList logItemList);

    /** Returns the index of the first occurrence of the specified LogItem element */
    public int indexOf(LogItem logItem);

    /** Removes all of the LogItem elements from this list
     * @return */
    public boolean clear();

    /** Returns filtered LogItem element at the specified index in this list */
    public LogItem get(int index);

    /** Returns the number of LogItems elements in this list. 
     * @throws IOException */
    public int size();

    /** get log items and sort them */
    public void sort(Comparator<LogItem> comparator);

    /**
     * Update an instance of LogItem element by replacing the element at the
     * specified position in this list with the specified LogItem element
     */
    public boolean updateLogItem(long index, LogItem logItem);
}
