/***********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.model;

/**
 * This class allows the LogTableViewer to use either a LogItemMatcher (for simple, single
 * keyword filtering) or a ComplexMatcher for more complicated filtering operations configured
 * through the FilterDialog. Both ComplexMatcher and LogItemMatcher implement this interface,
 * which extends the Matcher interface. To build an object
 * that implements this interface the factory method getMultiMatcher() in the class
 * MultiMatcherFactory determines the appropriate type of matcher based on the filtering
 * configured.
 */
public interface ISingleMatcher {

    public boolean matches(LogItem logItem);

}
