/***********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.model;

import java.io.File;
import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vmware.vide.vlogbrowser.core.utils.Preferences;


/**
 * A <code>LogItemListFactory</code> instance can be used to create
 * <code>ILogItemList</code> objects.
 */
public class LogItemListFactory {
    
    private static final String RA_PREFIX = "testRAFile_";
    private static final String RA_SUFIX = ".ra";
    
    private static final Logger logger = LoggerFactory.getLogger(LogItemListFactory.class);

    public enum EnumLogItemList {
        RAM,   // Random Access Memory
        RAFile // Random Access File
    }

    private static LogItemListFactory instance;
    private EnumLogItemList defaultType;
    private int totalFiles = 0;

    private LogItemListFactory() {
        defaultType = EnumLogItemList.RAFile;
        logger.debug("Using: " + defaultType.toString());
    }

    public static synchronized LogItemListFactory getInstance() {
        if (instance == null) {
            instance = new LogItemListFactory();
        }
        return instance;
    }

    /**
     * Create a <code>ILogItemList</code>.
     *
     * @param type
     *            define the type of list that will be created.
     * @return a new <code>ILogItemList</code> object.
     */
    public ILogItemList createLogItemList(EnumLogItemList type, String resName) {
        switch (type) {
        case RAM:
            return new LogItemListRAM();
        case RAFile:
//            String rootPath = Preferences.getInstance().getProperty(Preferences.ROOT_DIR);
//            if (rootPath == null) {
//                return null;
//            }
//            File raDir = new File(new File(rootPath),".vmwb/LogBrowser/ra/");
//            if (!raDir.exists()) {
//                raDir.mkdirs();
//            }
//            
//            String fileName =  RA_PREFIX + totalFiles++  + RA_SUFIX;
//
//            File file = new File(raDir, fileName);
//            if (file.exists()) {
//                file.delete();
//            }
//            LogItemListRAFile logItems = null;
//            try {
//                file.createNewFile();
//                logItems = new LogItemListRAFile(file);
//            } catch (Exception e) {
//               logger.error(e.getMessage(), e);
//            }
            
//            return createLogItemList(fileName); // TODO NILMAX create the LogItemListRAFile
            String rootPath = Preferences.getInstance().getProperty(
                    Preferences.ROOT_DIR);
            if (rootPath == null) {
                return null;
            }
            File raDir = new File(new File(rootPath), ".vmwb/LogBrowser/ra/");
            if (!raDir.exists()) {
                raDir.mkdirs();
            }
            File file = new File(raDir, resName);
            LogItemListRAFileBuffer logItems = null;
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }

                logItems = new LogItemListRAFileBuffer(file);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
            return logItems;
        default:
            return null;
        }
    }

    /**
     * Create a <code>ILogItemList</code>.
     *
     * @param type
     *            define the type of list that will be created.
     * @return a new <code>ILogItemList</code> object.
     */
    public ILogItemList createLogItemList() {
        String fileName =  RA_PREFIX + totalFiles++  + RA_SUFIX;
        return createLogItemList(defaultType, fileName);
    }

    public EnumLogItemList getDefaultType() {
        return defaultType;
    }

    public void setDefaultType(EnumLogItemList defaultType) {
        this.defaultType = defaultType;
    }

}
