package com.vmware.vide.vlogbrowser.core.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class LogItemListRAM implements ILogItemList {

    private List<LogItem> logItemList;

    public LogItemListRAM() {
        logItemList = new Vector<LogItem>();
    }

    @Override
    public boolean add(LogItem logItem) {
        boolean added = logItemList.add(logItem);
        return added;
    }

    @Override
    public boolean addAll(ILogItemList logItemList) {
        boolean added = false;
        if (logItemList instanceof LogItemListRAM) {
            LogItemListRAM logItemListRAM = (LogItemListRAM) logItemList;
            added = this.logItemList.addAll(logItemListRAM.getCollection());
        }
        return added;
    }

    // TODO NILMAX thing better about this
    private Collection<? extends LogItem> getCollection() {
        return logItemList;
    }

    @Override
    public int indexOf(LogItem logItem) {
        return logItemList.indexOf(logItem);
    }

    @Override
    public boolean clear() {
        logItemList.clear();
        return true;
    }

    @Override
    public LogItem get(int index) {
        return logItemList.get(index);
    }

    @Override
    public int size() {
        return logItemList.size();
    }

    // TODO NILMAX test comparator
    @Override
    public void sort(Comparator<LogItem> comparator) {
        LogItem[] items = logItemList.toArray(new LogItem[0]);
        Arrays.sort(items, comparator);
    }

    @Override
    public boolean updateLogItem(long index, LogItem logItem) {
        logItemList.set((int)index, logItem);
        return true;
    }
}
