/***********************************************************

 * Copyright 2010 VMware, Inc.  All rights reserved.

 * -- VMware Confidential

 ***********************************************************/



package com.vmware.vide.vlogbrowser.core.model;



/** Class for storing log file names, dir and system type used by log templates */

public class LogSystemType {

    // criteria for sorting files matching fileRegex pattern

    public enum SortMethod { Filename, Time, Filenum };



    private String system;

    private String version;

    private String parentDir;

    private String fileRegex;

    private String liveLogFilename;

    private boolean fileNumDescending;

    private SortMethod sortMethod;



    /** Create new LogSystemType instance */

    public LogSystemType(String system, String version,

            String parentDir, String fileRegex, String liveLog, boolean numDescending)

    {

        this(system, version, parentDir, fileRegex, liveLog, numDescending, SortMethod.Filename);

    }



    /** Create new LogSystemType instance */

    public LogSystemType(String system, String version,

            String parentDir, String fileRegex, String liveLog, boolean numDescending, SortMethod sortMethod)

    {

        this.system = system;

        this.version = version;

        this.parentDir = parentDir;

        this.fileRegex = fileRegex;

        this.liveLogFilename = liveLog;

        this.fileNumDescending = numDescending;

        this.sortMethod = sortMethod;

    }



    /** Returns system name, may include pattern to support several system types. Example: esx* */

    public String getSystem() {

        return system;

    }



    /** Returns system version, may include pattern to support several versions. Example: 4.* */

    public String getVersion() {

        return version;

    }



    /** Returns directory on the target system version where log files are located */

    public String getDir() {

        return parentDir;

    }



    /** Returns filename regex for target system log files */

    public String getFileRegex() {

        return fileRegex;

    }



    /** Returns true if log file numbers are in decending order (newer file has lower number) */

    public boolean isFileNumDescending() {

        return fileNumDescending;

    }



    /** Returns filename for the live log file */

    public String getLiveLogFilename() {

        return liveLogFilename;

    }



    /** Returns sort method for log files */

    public SortMethod getSortMethod() {

        return sortMethod;

    }



   @Override

    public boolean equals(Object obj) {

        if (obj == null || !(obj instanceof LogSystemType))

            return false;



        LogSystemType o = (LogSystemType)obj;

        boolean b1 = system.equals(o.getSystem());

        boolean b2 = version.equals(o.getVersion());

        boolean b3 = fileRegex.equals(o.getFileRegex());

        boolean b4 = parentDir.equals(o.getDir());



        return b1 && b2 && b3 && b4;

    }



}