/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/
package com.vmware.vide.vlogbrowser.core.parser;

import java.io.IOException;

public interface ILineReader {
    /**
     * Read a line and returns number of bytes of the line.
     * The number of byte of the line includes the byte sequence of the end of the line.
     * @param sb Appends characters in the read line.
     * @return number of bytes of the read line. -1 if reaches to the end of file.
     * @throws IOException I/O error
     */
    int readLine(StringBuilder sb) throws IOException;
    /**
     * Close the stream.
     * @throws IOException I/O error.
     */
    void close() throws IOException;
}
