/***********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.model.ISingleMatcher;
import com.vmware.vide.vlogbrowser.core.model.LogItem;

/**
 * The IndexMatcher class is primarily used to locate a log entry by its index number.
 * It checks each cell in the LogItem object to see if it matches the configured "search"
 * index number.
 */
public class IndexMatcher implements ISingleMatcher {

    private long searchIndexNum;

    public IndexMatcher(long indexNum) {
        this.searchIndexNum = indexNum;
    }

    public IndexMatcher(String indexNumStr) throws NumberFormatException {
        this(Long.parseLong(indexNumStr));
    }

    @Override
    public boolean matches(LogItem logItem) {
        if (searchIndexNum == logItem.getLogIndexNum()) {
            return true;
        } else {
            return false;
        }
    }

}
