/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/
package com.vmware.vide.vlogbrowser.core.parser;

import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Set;

public class LineReaderFactory {
    static private final String[] lfLineReaderSupport = {
        "UTF8", "UTF-8",
        "ISO-8859-1", "ISO8859_1",
        "US-ASCII", "ASCII",
        "windows-1252", "Cp1252"
    };
    static private Set<String> lfCharset = new HashSet<String>();
    static {
        for (String cs : lfLineReaderSupport) {
            lfCharset.add(cs);
        }
    }

    static private boolean isLfLineReaderSupport(String charEncode) {
        return lfCharset.contains(charEncode);
    }

    static ILineReader createLineReader(FileInputStream fis, String charEncode) {
        if (isLfLineReaderSupport(charEncode)) {
            return new LFLineReader(fis, charEncode);
        }
        return new LineReader(fis, charEncode);
    }
}
