/***********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.model.ISingleMatcher;
import com.vmware.vide.vlogbrowser.core.model.LogItem;

/**
 * This class allows the LogTableViewer to use either a LogItemMatcher (for simple, single
 * keyword filtering) or a ComplexMatcher for more complicated filtering operations configured
 * through the FilterDialog. Both ComplexMatcher and LogItemMatcher implement this interface,
 * which extends the Matcher interface that GlazedLists is expecting. To build an object
 * that implements this interface the factory method getMultiMatcher() in the class
 * MultiMatcherFactory determines the appropriate type of matcher based on the filtering
 * configured.
 */
public interface MultiMatcher extends ISingleMatcher {

    public boolean matches(LogItem logItem);

    public boolean matchesSomeField(LogItem logItem);

}
