/***********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.model.LogFilter;

/**
 * The MultiMatcher factory has the logic to return the best matcher (i.e. the best class that
 * implements the MultiMatcher interface) based on the LogFilter configured.
 */
public class MultiMatcherFactory {

    public static MultiMatcher getMultiMatcher(LogFilter logFilter,
                                               LogFormat logFormat) throws Exception {
        if (logFilter.isJustAKeyword()) {
            return new LogItemMatcher(logFilter, logFormat);
        } else {
            return new ComplexMatcher(logFilter, logFormat);
        }
    }

}
