/***********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * The XmlDocUtils class contains a number of static helper methods used to
 * manipulate XML files and retrieve information from them.
 */
public class XmlDocUtils {

    public static void replaceXmlElement(Document myDoc, String elementName,
            String newValue) {
        Node rootNode = myDoc.getFirstChild();
        NodeList removeList = myDoc.getElementsByTagName(elementName);
        int removeLimit = removeList.getLength();
        for (int i = 0; i < removeLimit; i++) {
            rootNode.removeChild(removeList.item(i));
        }
        Element replacementElement = myDoc.createElement(elementName);
        replacementElement.appendChild(myDoc.createTextNode(newValue));
        rootNode.appendChild(replacementElement);
    }

    public static Document parseXmlFromFile(File xmlFile)
            throws ParserConfigurationException, SAXException, IOException {
        return parseXmlFromInputStream(new FileInputStream(xmlFile));
    }

    public static Document parseXmlFromInputStream(InputStream in)
            throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBldrFactory = DocumentBuilderFactory
                .newInstance();
        DocumentBuilder docBldr = docBldrFactory.newDocumentBuilder();
        Document xmlDoc = docBldr.parse(in);
        in.close();
        return xmlDoc;
    }

    /**
     * Convert the DOM object into an XML string
     * 
     * @author fincht
     * @return String
     */
    public static String getXmlStringFromDocument(Document myDoc) {
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource domSource = new DOMSource(myDoc);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty(OutputKeys.METHOD, "xml");
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");
            transformer.setOutputProperty(
                    "{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty(OutputKeys.STANDALONE, "yes");
            transformer.transform(domSource, result);
            return writer.getBuffer().toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getElement(Document myDoc, String pathAndName)
            throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String elementValue = null;
        try {
            elementValue = xpath.evaluate(pathAndName + "/text()", myDoc);
        } catch (Exception e) {
            throw new Exception(
                    "There was an XML parsing problem while locating "
                            + pathAndName);
        }
        if ((elementValue == null) || (elementValue.length() == 0)) {
            throw new Exception(pathAndName
                    + " is missing from the XML configuration.");
        }
        return elementValue;
    }

    public static String[] getElements(Document myDoc,
            String parentElementPath, String optionalChildElement)
            throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        int numNodes = Integer.parseInt(xpath.evaluate("count("
                + parentElementPath + ")", myDoc));
        String[] returnArr = new String[numNodes];
        String extraPath = (optionalChildElement == null) ? ""
                : optionalChildElement + "/";
        for (int i = 1; i <= numNodes; i++) {
            String nodeNumStr = Integer.toString(i);
            returnArr[i - 1] = xpath.evaluate(parentElementPath + "["
                    + nodeNumStr + "]/" + extraPath + "text()", myDoc);
        }
        return returnArr;
    }

}
