/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.runners;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vmware.vide.vlogbrowser.core.model.LogFilter;

/**
 * Runner class for running a filter operation in the log table viewer. Since a filter operation
 * can be time consuming, a progress monitor is invoked by this class.
 */
public class BaseLogFilterRunner implements Runnable {
    
    private static final Logger logger = LoggerFactory.getLogger(BaseLogFilterRunner.class);

    protected LogFilter logFilter;

    public BaseLogFilterRunner(LogFilter logFilter) {
        this.logFilter = logFilter;
    }

//    // Override by derived classes
//    public void showError(String message) {
//
//    }
//    
//    // Override by derived classes
    public void updateFilter() throws Exception {

    }

    @Override
    public void run() {
        try {
            if (! logFilter.isFilterEnabled()) {
                logger.info("Unfiltering...");
            } else {
                String filterMsg = "Filtering ";
                if (! logFilter.isJustAKeyword()) {
                    filterMsg += "on a filter expression named '" + logFilter.getName() + "'";
                } else {
                    filterMsg += "on keyword '" + logFilter.getFirstKeyword() + "'";
                }
                int additionalFilterLines = logFilter.getNumSurroundingLines();
                if (additionalFilterLines > 0) {
                       filterMsg += " with " + additionalFilterLines + " surrounding line" +
                       ((additionalFilterLines == 1) ? "" : "s");
                }
                logger.info(filterMsg);
                updateFilter();
            }
        } catch (Exception e) {
            logger.error("While trying to perform filter operation an error occurred.", e);
        }
    }
}
