/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.core.utils;

import com.vmware.vide.vlogbrowser.core.fileops.LogFileManager;

public class Utils {
    public static String getPathSep(String hostname) {
        if (hostname.equalsIgnoreCase(LogFileManager.LOCALHOST)) {
            return System.getProperty("file.separator");
        } else {
            return "/";  // only Windows uses \ and remote Windows log retrieval is not supported
        }
    }

    public static boolean isPlatformWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }
}
