package com.vmware.vide.vlogbrowser.service;

import java.net.URL;
import java.util.Date;
import java.util.List;

import com.vmware.vide.vlogbrowser.service.model.FilterResult;
import com.vmware.vide.vlogbrowser.service.model.LogEntries;
import com.vmware.vide.vlogbrowser.service.model.ProgressResult;
import com.vmware.vide.vlogbrowser.service.model.ProjectManifest;
import com.vmware.vide.vlogbrowser.service.model.ResourceInfo;

public interface ILogBrowserService {
    // @GET
    // @Path("/{project}/manifest/")
    List<ProjectManifest> getProjectManifest() throws Exception;

    // @POST
    // @Path("/{project}/{resource}/refresh-progress/")
    // @Consumes("application/xml")
    ProgressResult requestProgress(String resName) throws Exception;

    // @POST
    // @Path("/{project}/{resource}/refresh/")
    // @Consumes("application/xml")
    ProgressResult refreshLogs(String resName, ResourceInfo info)
            throws Exception;

    // @GET
    // @Path("/{project}/{resource}/count/")
    Integer getCount(String resName) throws Exception;

    // @GET
    // @Path("/{project}/{resource}/entries/")
    // @Produces("application/xml;charset=UTF-8")
    LogEntries getEntries(String resName, String filterString, int firstIndex,
            int count) throws Exception;

    // @POST
    // @Path("/{project}/{resource}/adjust/")
    void adjustTime(String resName, long dateDelta) throws Exception;

    // @GET
    // @Path("/{project}/{resource}/filter/")
    List<FilterResult> getFilters(String resName) throws Exception;

    // @GET
    // @Path("/{project}/{resource}/filter/{id}/")
    FilterResult getFilters(String resName, String filterName) throws Exception;

    // @POST
    // @Path("/{project}/{resource}/filter/")
    void applyFilter(String resName, String filterString, int aroundString)
            throws Exception;

    // @POST
    // @Path("/{project}/{resource}/filter/{id}")
    void applyFilter(String resName, String filterString) throws Exception;

    // @POST
    // @Path("/{project}/{resource}/filter/{id}/save/")
    // @Consumes("application/xml")
    void saveFilter(String resName, String filterName, FilterResult filterResult)
            throws Exception;

    // @POST
    // @Path("/{project}/{resource}/filter/{id}/delete/")
    void deleteFilter(String resName, String filterName) throws Exception;

    // @GET
    // @Path("/{project}/{host}/download")
    // @Produces("application/octet-stream")
    URL fetchLogFileOrBundle(String hostName, String resName)
            throws Exception;

    // @POST
    // @Path("/{project}/{host}/delete")
    void deleteAllLogsFromHost(String hostName) throws Exception;

    Integer[] findIndexByDateTime(String resName, int firstIndex, Date dateTime)
            throws Exception;

    Integer[] findIndexByText(String resName, int firstIndex, String pattern)
            throws Exception;
}
