package com.vmware.vide.vlogbrowser.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LogProjectManager {

    protected List<LogFileAnalyzer> files;

    private File root;
    
    private File defaultProject;

    public static final String PROJECT_DEFAULT_NAME = "Log Analysis";

    public LogProjectManager(String rootDirectory) {
        this(new File(rootDirectory));
    }

    public LogProjectManager(File rootDirectory) {
        files = new ArrayList<LogFileAnalyzer>();

        root = rootDirectory;

        defaultProject = new File(root, PROJECT_DEFAULT_NAME);
        if (!defaultProject.exists()) {
            defaultProject.mkdirs();
        }
    }

    public String getLocation() {
        return root.getAbsolutePath();
    }

    public List<File> getProjectsDir() {
        List<File> result = new ArrayList<File>();
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                result.add(f);
            }
        }
        return result;
    }

    public LogFileAnalyzer findLogFileAnalyzer(String location) {
        for (LogFileAnalyzer f : files) {
            if (f._location.equals(location))
                return f;
        }
        return null;
    }

    public LogFileAnalyzer findLogFileAnalyzer(String prjName, String resName) {
        File project = find(prjName);
        if (project == null) {
            return null;
        }
        String location = project.getAbsolutePath() + File.separator + resName;
        return findLogFileAnalyzer(location);
    }

    public LogFileAnalyzer getLogFileAnalyzer(String prjName, String resName) {
        File project = find(prjName);
        if (project == null) {
            return null;
        }
        String location = project.getAbsolutePath().toString() + File.separator
                + resName;
        LogFileAnalyzer f = findLogFileAnalyzer(location);
        if (f != null) {
            return f;
        }
        f = new LogFileAnalyzer(resName, location);
        files.add(f);
        return f;
    }
    
    public LogFileAnalyzer getLogFileAnalyzer(String resName) {
        return getLogFileAnalyzer(LogProjectManager.PROJECT_DEFAULT_NAME, resName);
    }

    public void remove(String prjName, String resName) {
        File project = find(prjName);
        if (project == null) {
            return;
        }
        String location = project.getAbsolutePath().toString() + File.separator
                + resName;
        LogFileAnalyzer f = findLogFileAnalyzer(location);
        if (f == null) {
            return;
        }
        files.remove(f);
    }

    public File find(String name) {
        for (File f : root.listFiles()) {
            if (f.isDirectory() && f.getName().equals(name)) {
                return f;
            }
        }
        return null;
    }
    
    public File getDefaultProject() {
        return defaultProject;
    }
}
