/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.service.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Class to return log file column information.
 * This information is static, since it depends
 * on the type of the file, not the actual content
 * of a log file.
 *
 * @author gcaprino
 */

@XmlRootElement(name = "ColumnData")
public class ColumnDataResult {
    private String fieldName;
    private boolean fieldVisible;
    private int fieldWidth;

    @XmlElement
    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String value) {
        fieldName = value;
    }

    @XmlElement
    public int getFieldWidth() {
        return fieldWidth;
    }

    public void setFieldWidth(int value) {
        fieldWidth = value;
    }

    @XmlElement(name = "isVisible")
    public boolean isVisible() {
        return fieldVisible;
    }

    public void setVisible(boolean value) {
        fieldVisible = value;
    }

}
