/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.service.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Class to return a single filter condition.
 * Conditions can be connected through AND or
 * OR operators. A separate class handles
 * sets of conditions.
 *
 * @author gcaprino
 */

@XmlRootElement(name = "Condition")
public class FilterConditionResult {

    private String pattern;
    private Boolean isNot;
    private Boolean isRegEx;
    private String operator;

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @XmlElement(name = "isNot")
    public Boolean isNot() {
        return isNot;
    }

    public void setNot(Boolean _isNot) {
        this.isNot = _isNot;
    }

    @XmlElement(name = "isRegEx")
    public Boolean isRegEx() {
        return isRegEx;
    }

    public void setRegEx(Boolean _isRegEx) {
        this.isRegEx = _isRegEx;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String _operator) {
        this.operator = _operator;
    }

}
