/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.service.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Class to return a row of filter conditions.
 * The current Log Browser implementation supports
 * conditions in a row-column matrix. This class
 * represents a row of conditions. A different
 * class represents a set of rows.
 *
 * @author gcaprino
 */

@XmlRootElement(name="Row")
public class FilterConditionRowResult {

    private List<FilterConditionResult>   _conditions;

    @XmlElement(name="Condition")
    public List<FilterConditionResult> getRow() {
        return _conditions;
    }

    public void setRow(List<FilterConditionResult> _rows) {
        this._conditions = _rows;
    }

    public void addCondition(FilterConditionResult condition) {
        if (_conditions == null) {
            _conditions = new ArrayList<FilterConditionResult>();
        }
        _conditions.add(condition);
    }

}
