/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.service.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts.BooleanConnector;
import com.vmware.vide.vlogbrowser.core.model.FilterItem;
import com.vmware.vide.vlogbrowser.core.model.LogFilter;

/**
 * Class describing a complex (named) filter.
 *
 * @author gcaprino
 */

@XmlRootElement(name = "Filter")
public class FilterResult {

    private String name;            // the name of the filter
    private List<FilterConditionRowResult> conditions;    // the rows describing the conditions

    @XmlElement(name = "Name")
    public String getFilterName() {
        return name;
    }

    public void setFilterName(String name) {
        this.name = name;
    }

    @XmlElement
    public List<FilterConditionRowResult> getConditions() {
        return conditions;
    }

    public void setConditions(List<FilterConditionRowResult> s) {
        conditions = s;
    }

    public void setFilter(LogFilter filter) {
        int nRows = filter.getFilterRowCount();
        int row;
        int col;
        conditions = new ArrayList<FilterConditionRowResult>();
        for (row = 0; row < nRows; ++row) {
            int nCols = filter.getFilterColumnCount(row);
            if (nCols < 1) {
                continue;
            }
            FilterConditionRowResult condRow = new FilterConditionRowResult();
            for (col = 0; col < nCols; ++col) {
                FilterConditionResult cond = new FilterConditionResult();
                try {
                    FilterItem item = filter.getFilterItem(row, col);
                    BooleanConnector op = item.getBoolConnector();
                    switch (op) {
                    case AND:
                        cond.setOperator("AND");
                        break;

                    case OR:
                        cond.setOperator("OR");
                        break;
                    }
                    if (item.isNegateFlagSet()) {
                        cond.setNot(true);
                    }
                    if (item.isRegexFlagSet()) {
                        cond.setRegEx(true);
                    }
                    cond.setPattern(item.getKeyword());
                } catch (Exception e) {
                    e.printStackTrace();
                }
                condRow.addCondition(cond);
            }
            conditions.add(condRow);
        }
    }

}
