/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.service.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Class describing a log entry.
 * A list of these log entries is returned
 * to clients.
 *
 * @author gcaprino
 */

@XmlRootElement(name = "LogEntry")
public class LogEntryResult {

    private String[] values;
    private String time;
    private String group;
    private String extraLines;

    public LogEntryResult() {
        values = new String[0];
    }

    @XmlElement(name = "value")
    public String[] getValues() {
        return values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    @XmlElement
    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    @XmlElement
    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @XmlElement
    public String getExtraLines() {
        return extraLines;
    }

    public void setExtraLines(String extraLines) {
        this.extraLines = extraLines;
    }

}
