/***********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.service.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.vmware.vide.vlogbrowser.core.model.LogFilter;

/**
 * Class to return LogEntry results to a web client.
 * Note that each log file may have a different
 * format, thus we cannot return the individual
 * fields of a log entry. Instead we return an
 * array of Strings.
 * Subsets of the class private variables are returned
 * for different requests.
 *
 * @author gcaprino
 */

@XmlRootElement(name = "LogFile")
public class LogTableResult {
    public static final String DONE = "done";
    public static final String WORKING = "working";
    public static final String ERROR = "error";
    private List<LogEntryResult> values;
    private List<FilterResult> filters;
    private String time;
    private String status;      // working, done
    private String[] columns;   // header of each column
    private Integer nEntries;   // number of rows in this log
    private Integer[] findRows; // rows that match a find pattern search

    public LogTableResult() {
        values = new ArrayList<LogEntryResult>();
        status = DONE;
    }

    @XmlElement
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @XmlElement
    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    @XmlElement
    public List<LogEntryResult> getRows() {
        return values;
    }

    public void setRows(List<LogEntryResult>values) {
        this.values = values;
    }

    @XmlElement
    public String[] getColumns() {
        return columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    // for /{project}/{resource}/find/ request

    @XmlElement(name = "findRow")
    public Integer[] getFindRows() {
        return findRows;
    }

    public void setFindRows(Integer[] findRows) {
        this.findRows = findRows;
    }

    // for /{project}/{resource}/count/ request

    @XmlElement
    public Integer getNumEntries() {
        return nEntries;
    }

    public void setNumEntries(int n) {
        nEntries = n;
    }

    // for /{project}/{resource}/filters/ request

    @XmlElement
    public List<FilterResult> getFilters() {
        return filters;
    }

    public void setFilters(List<FilterResult> filters) {
        this.filters = filters;
    }

    public void addFilter(String name, LogFilter f) {
        if (filters == null) {
            filters = new ArrayList<FilterResult>();
        }
        FilterResult flt = new FilterResult();
        flt.setFilterName(name);
        flt.setFilter(f);
        filters.add(flt);
    }

}
