/***********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 ***********************************************************/

package com.vmware.vide.vlogbrowser.service.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Class that holds the progress' status, percentage and logFileResult to be returned to a web client.
 */
@XmlRootElement(name = "ProgressResult")
public class ProgressResult implements Cloneable{

    public enum ProgressStatus {
        BUSY, DONE, ERROR
    }

    private LogFileResult logFileResult = new LogFileResult();
    private ProgressStatus status = ProgressStatus.DONE;
    private int progressPercentage = 0;

    private long work = 0;
    private long totalWork = 0;

    public ProgressResult() {
    }

    public void setLogFileResult(LogFileResult logFileResult) {
        this.logFileResult = logFileResult;
    }

    public LogFileResult getLogFileResult() {
        return logFileResult;
    }

    @XmlElement
    public synchronized int getProgressPercentage() {
        return (progressPercentage > 100) ? 100 : progressPercentage;
    }

    @XmlElement
    public ProgressStatus getStatus() {
        return status;
    }

    public void setStatus(ProgressStatus status) {
        this.status = status;
    }

    public synchronized void incrementWork(int i) {
        work += i;
        progressPercentage = (int) (((double) work / totalWork) * 100);
    }

    public void setTotalWork(long progressTotalWork) {
        this.totalWork = progressTotalWork;
    }

    @Override
    public ProgressResult clone() throws CloneNotSupportedException {
        ProgressResult result = new ProgressResult();
        result.status = ProgressStatus.valueOf(this.status.toString());
        result.progressPercentage = this.progressPercentage;
        result.work = this.work;
        result.totalWork = this.totalWork;
        return result;
    }
}
